/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.koiroha.jive2ch.J2Bean;
import org.koiroha.jive2ch.util.TextUtil;
import org.koiroha.xml.Html;

public class Response
extends J2Bean {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Response.class.getName());
    private int num = 0;
    private final String author;
    private final String mail;
    private final String misc;
    private final Date date;
    private final String id;
    private final String be;
    private final String content;
    private String plain = null;
    private boolean asciiArt = false;
    private boolean recent = false;
    private boolean ng = false;
    private boolean damepo = false;
    private String title = null;

    private Response(String author, String mail, String misc, String content) {
        this.author = author;
        this.mail = mail;
        this.misc = misc;
        this.content = content;
        Pattern p = Pattern.compile("(\\d+)/(\\d+)/(\\d+)\\(.\\)\\s+(\\d+):(\\d+):(\\d+)(\\.(\\d+))?");
        Matcher m = p.matcher(misc);
        if (m.find()) {
            int YY = Integer.parseInt(m.group(1));
            int MM = Integer.parseInt(m.group(2));
            int DD = Integer.parseInt(m.group(3));
            int hh = Integer.parseInt(m.group(4));
            int mm = Integer.parseInt(m.group(5));
            int ss = Integer.parseInt(m.group(6));
            if (YY < 100) {
                YY += 2000;
            } else if (YY < 200) {
                YY += 1900;
            }
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("JST"));
            cal.set(YY, MM, DD, hh, mm, ss);
            if (m.groupCount() == 8 && m.group(8) != null) {
                int milli = Integer.parseInt(m.group(8));
                switch (m.group(8).length()) {
                    case 1: {
                        milli *= 100;
                        break;
                    }
                    case 2: {
                        milli *= 10;
                        break;
                    }
                }
                cal.set(14, milli);
            } else {
                cal.set(14, cal.getActualMinimum(14));
            }
            this.date = cal.getTime();
            misc = misc.substring(0, m.start()) + misc.substring(m.end());
        } else {
            this.date = null;
        }
        p = Pattern.compile("ID:([^\\s]+)");
        m = p.matcher(misc);
        if (m.find()) {
            this.id = m.group(1);
            misc = misc.substring(0, m.start()) + misc.substring(m.end());
        } else {
            this.id = null;
        }
        p = Pattern.compile("BE:([^\\s]+)");
        m = p.matcher(misc);
        if (m.find()) {
            this.be = m.group(1);
            misc = misc.substring(0, m.start()) + misc.substring(m.end());
        } else {
            this.be = null;
        }
        if (misc.trim().length() > 0) {
            logger.fine("misc\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u672a\u78ba\u8a8d\u306e\u30c7\u30fc\u30bf\u304c\u6b8b\u3063\u3066\u3044\u307e\u3059: " + misc.trim());
        }
        this.asciiArt = TextUtil.isAsciiArt(this);
    }

    public Response(String author, String mail, String content) {
        this(author, mail, new SimpleDateFormat("yyyy/MM/dd(E) HH:mm:ss").format(new Date()), content);
    }

    public int getNumber() {
        return this.num;
    }

    public void setNumber(int num) {
        this.num = num;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getMail() {
        return this.mail;
    }

    public String getMisc() {
        return this.misc;
    }

    public Date getDate() {
        return this.date;
    }

    public String getId() {
        return this.id;
    }

    public String getBe() {
        return this.be;
    }

    public String getContent() {
        return this.content;
    }

    public String getPlainText() {
        if (this.plain == null) {
            String str = this.content;
            str = str.replaceAll("(?i)<br\\s*/?>", "\n");
            str = str.replaceAll("(?i)<a\\s+[^>]*>([^<]*)</a>", "$1");
            str = str.replaceAll("(?i)<hr\\s*[^>]*>", "");
            this.plain = str = Html.unescape(str);
        }
        return this.plain;
    }

    public boolean isNew() {
        return this.recent;
    }

    public void setNew(boolean recent) {
        this.recent = recent;
    }

    public boolean isAsciiArt() {
        return this.asciiArt;
    }

    public void setAsciiArt(boolean aa) {
        this.asciiArt = aa;
    }

    public boolean isNG() {
        return this.ng;
    }

    public void setNG(boolean ng) {
        this.ng = ng;
    }

    public boolean isDamepo() {
        return this.damepo;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public static Response parse(String line) {
        Response res = null;
        try {
            String[] elem = line.split("<>");
            res = new Response(elem[0], elem[1], elem[2], elem[3]);
            if (elem.length > 4) {
                res.title = elem[4];
            }
        }
        catch (RuntimeException ex) {
            logger.log(Level.FINE, "dat\u884c\u306e\u5185\u5bb9\u304c\u4e0d\u6b63\u3067\u3059: " + line, ex);
            res = new Response("</b>\u3082\u3046\u3060\u3081\u307d<b>", "", "\u3082\u3046\u3060\u3081\u307d", Html.escape(line));
            res.damepo = true;
        }
        return res;
    }
}

