/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.koiroha.jive2ch.util.AWT;
import org.koiroha.jive2ch.util.IO;

public class Resource {
    private static final Properties BASE = new Properties();
    private Properties config = new Properties(BASE);

    public String getString(String key) throws IllegalArgumentException {
        String value = this.config.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException(key);
        }
        return value;
    }

    public static URL getResource(String fileName) throws IllegalArgumentException {
        String name = "org/koiroha/jive2ch/resources/" + fileName;
        URL url = Resource.class.getResource(name);
        if (url == null) {
            name = "/" + name;
            url = Resource.class.getResource(name);
        }
        if (url == null) {
            throw new IllegalArgumentException(fileName);
        }
        return url;
    }

    public static Image loadImage(Display display, String fileName) {
        return Resource.loadImage(display, fileName, -1, -1);
    }

    public static Image loadImage(Display display, String fileName, int width, int height) {
        URL url = Resource.getResource(fileName);
        return Resource.loadImage(display, url, width, height);
    }

    public static Image loadImage(Display display, URL url, int width, int height) {
        if (width > 0 && height > 0) {
            return new Image((Device)display, new ByteArrayInputStream(AWT.getImage(url, width, height)));
        }
        InputStream in = null;
        try {
            in = url.openStream();
            Image image = new Image((Device)display, in);
            return image;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            IO.close(in);
        }
    }

    static {
        ResourceBundle res = ResourceBundle.getBundle("org.koiroha.jive2ch.resource");
        Enumeration<String> en = res.getKeys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            String value = res.getString(key);
            BASE.setProperty(key, value);
        }
    }
}

