/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.koiroha.jive2ch.Category;
import org.koiroha.jive2ch.Jive2ch;
import org.koiroha.jive2ch.RepositoryLockException;
import org.koiroha.jive2ch.client.SessionManager;
import org.koiroha.jive2ch.func.SkinManager;
import org.koiroha.jive2ch.gui.Scrap;
import org.koiroha.jive2ch.util.AADB;
import org.koiroha.jive2ch.util.Debug;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.J2Formatter;
import org.koiroha.jive2ch.util.RollbackOutputStream;

public class Repository {
    private static final Logger logger = Logger.getLogger(Repository.class.getName());
    private static final String LOGGING_FILE = "logging.properties";
    private static final String LOCK_FILE = ".lock";
    private static final String BBSMENU_FILE = "cache" + File.separator + "bbsmenu.html";
    private final File dir;
    private final FileChannel lock;
    private final Timer logSettingWatchdog = new Timer("LogSettingWatchdog", true);
    public final File localTemplateFile;
    public final File kakikomiFile;
    public final File kakikomiKariHozon;
    public final File ngWordFile;
    public final File favouriteFile;

    public Repository(File dir) throws IOException {
        this.dir = dir;
        if (!dir.exists()) {
            this.init();
        }
        this.setupLogging();
        logger.info("Jive2ch " + Jive2ch.APP_VER + "." + Jive2ch.APP_SUBVER + " (build " + Jive2ch.APP_BUILD + ") \u3092\u8d77\u52d5\u3057\u3066\u3044\u307e\u3059...");
        logger.finer("\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3\n" + Debug.getDiagnostic());
        File lock = this.getFile(LOCK_FILE);
        this.lock = new FileOutputStream(lock).getChannel();
        if (this.lock.tryLock() == null) {
            throw new RepositoryLockException();
        }
        SessionManager manager = new SessionManager(this.getFile("cookie"));
        CookieHandler.setDefault(manager);
        this.logSettingWatchdog.scheduleAtFixedRate(new TimerTask(){
            private final File file;
            private long lastModified;
            {
                this.file = Repository.this.getFile(Repository.LOGGING_FILE);
                this.lastModified = this.file.lastModified();
            }

            @Override
            public void run() {
                if (this.lastModified != this.file.lastModified()) {
                    Repository.this.setupLogging();
                    this.lastModified = this.file.lastModified();
                    logger.finer("\u30ed\u30b0\u51fa\u529b\u8a2d\u5b9a\u3092\u8aad\u307f\u8fbc\u307f\u307e\u3057\u305f: logging.properties");
                }
            }
        }, 3000L, 3000L);
        this.localTemplateFile = new File(dir, "tmp" + File.separator + "index.html");
        this.kakikomiFile = new File(dir, "kakiko.txt");
        this.kakikomiKariHozon = new File(dir, "kari.xml");
        this.ngWordFile = new File(dir, "ngword.xml");
        this.favouriteFile = new File(dir, "favourite.txt");
        File cookie = new File(dir, "cookie.txt");
        SessionManager sm = new SessionManager(cookie);
        CookieHandler.setDefault(sm);
    }

    public void close() {
        this.logSettingWatchdog.cancel();
        IO.close(this.lock);
        this.getFile(LOCK_FILE).delete();
    }

    private void init() throws IOException {
        logger.info("\u30ea\u30dd\u30b8\u30c8\u30ea\u3092\u521d\u671f\u5316\u3057\u3066\u3044\u307e\u3059...: " + this.dir);
        IO.mkdir(this.dir);
        String handler = ConsoleHandler.class.getName();
        Properties logging = new Properties();
        logging.setProperty("handlers", handler);
        logging.setProperty(".level", "INFO");
        logging.setProperty(handler + ".level", "ALL");
        logging.setProperty(handler + ".formatter", J2Formatter.class.getName());
        this.store(LOGGING_FILE, logging);
        logger.info("\u30ea\u30dd\u30b8\u30c8\u30ea\u306e\u521d\u671f\u5316\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupLogging() {
        BufferedInputStream in = null;
        try {
            in = this.getInputStream(LOGGING_FILE);
            LogManager.getLogManager().readConfiguration(in);
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "\u30ed\u30b0\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
        }
        finally {
            IO.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String fileName, Properties prop) throws IOException {
        File file = this.getFile(fileName);
        RollbackOutputStream out = null;
        try {
            out = new RollbackOutputStream(file);
            prop.store(out, "");
        }
        catch (Throwable throwable) {
            IO.close(out);
            throw throwable;
        }
        IO.close(out);
        logger.fine("\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u3092\u66f8\u304d\u8fbc\u307f\u307e\u3057\u305f: " + fileName);
    }

    public Scrap createScrap() throws IOException {
        return new Scrap(this.getFile("scrap.properties"));
    }

    public BufferedInputStream getInputStream(String fileName) throws IOException {
        File file = this.getFile(fileName);
        return new BufferedInputStream(new FileInputStream(file));
    }

    public BufferedOutputStream getOutputStream(String fileName) throws IOException {
        File file = this.getFile(fileName);
        if (!file.getParentFile().exists()) {
            IO.mkdir(file.getParentFile());
        }
        return new BufferedOutputStream(new RollbackOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Category> readCategories(Jive2ch app) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(this.getFile(BBSMENU_FILE)));
            List<Category> list = Category.parse(app, in, IO.SJIS.name());
            IO.close(in);
            return list;
        }
        catch (FileNotFoundException ex) {
            List<Category> list = Collections.emptyList();
            return list;
        }
        finally {
            IO.close(in);
        }
    }

    public File getBBSMenuFile() {
        return this.getFile(BBSMENU_FILE);
    }

    public SkinManager createSkinManager() throws IOException {
        File dir = this.getFile("skins");
        return new SkinManager(dir);
    }

    public File getPluginDirectory() {
        return this.getFile("plugins");
    }

    public AADB createAADB() throws IOException {
        File dir = this.getFile("aa");
        return new AADB(dir);
    }

    public File getBoardDirectory(URI uri) {
        File server = this.getServerDirectory(uri);
        String path = (uri = uri.normalize()).getPath();
        path = path == null ? "" : path.replace('/', File.separatorChar);
        return new File(server, path + File.separator);
    }

    public File getServerDirectory(URI uri) {
        String host = (uri = uri.normalize()).getHost();
        if (host == null) {
            host = "localhost";
        }
        return this.getServerDirectory(host);
    }

    public File getServerDirectory(String host) {
        assert (host != null);
        return new File(this.dir, "cache" + File.separator + host + File.separator);
    }

    private File getFile(String fileName) {
        return new File(this.dir, fileName);
    }
}

