/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.program.Program;
import org.koiroha.jive2ch.gui.Jive2chFrame;

public class Platform {
    private static final Logger logger = Logger.getLogger(Platform.class.getName());
    private static final Platform PLATFORM = Platform.createPlatform();
    public static final int META = PLATFORM.getMenuAccelaraterModifier();

    protected Platform() {
    }

    public static final Platform getPlatform() {
        return PLATFORM;
    }

    public void setApplicationWindow(Jive2chFrame frame) {
    }

    public OS getOS() {
        return OS.UNKNOWN;
    }

    public String getKeyStrokeLabel(int keyStroke) {
        List<String> meta = this.getMetaKeyLabel(keyStroke & SWT.MODIFIER_MASK);
        meta.add(String.valueOf((char)keyStroke & 0xFFFF));
        StringBuilder buffer = new StringBuilder();
        for (String k : meta) {
            if (buffer.length() > 0) {
                buffer.append('+');
            }
            buffer.append(k);
        }
        return buffer.toString();
    }

    protected List<String> getMetaKeyLabel(int keyStroke) {
        assert ((keyStroke & SWT.MODIFIER_MASK) == keyStroke) : "\u4fee\u98fe\u30ad\u30fc\u4ee5\u5916\u306e\u30d3\u30c3\u30c8\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059";
        int[] code = new int[]{0x400000, 65536, 262144, 131072};
        ArrayList<String> label = new ArrayList<String>();
        for (int i = 0; i < code.length; ++i) {
            if ((keyStroke & code[i]) == 0) continue;
            label.add(this.getModifierKeyString(code[i]));
            keyStroke &= ~code[i];
        }
        if (keyStroke != 0) {
            label.add(String.format("%04X", keyStroke));
        }
        return label;
    }

    protected int getMenuAccelaraterModifier() {
        return 262144;
    }

    protected String getModifierKeyString(int key) {
        switch (key) {
            case 0x400000: {
                return "COMMAND";
            }
            case 65536: {
                return "ALT";
            }
            case 262144: {
                return "CTRL";
            }
            case 131072: {
                return "SHIFT";
            }
        }
        return String.format("%04X", key);
    }

    protected String getKeyString(int key) {
        switch (key) {
            case 8: {
                return "BS";
            }
            case 27: {
                return "ESC";
            }
            case 13: {
                return "CR";
            }
            case 10: {
                return "LF";
            }
        }
        return String.valueOf((char)key);
    }

    public boolean execute(File file) {
        Program prog;
        String ext = "";
        int sep = file.getName().lastIndexOf(46);
        if (sep >= 0) {
            ext = file.getName().substring(sep);
        }
        if ((prog = Program.findProgram(ext)) == null || prog.execute(file.getAbsolutePath())) {
            logger.finer("\u30d5\u30a1\u30a4\u30eb\u3092\u8d77\u52d5\u3057\u307e\u3057\u305f: " + file);
            return true;
        }
        try {
            logger.finer("\u30ea\u30d5\u30ec\u30af\u30b7\u30e7\u30f3\u3092\u4f7f\u7528\u3057\u3066 JSE 6 Desktop \u306e\u8d77\u52d5\u3092\u8a66\u307f\u3066\u3044\u307e\u3059");
            Class<?> clazz = Class.forName("java.awt.Desktop");
            Method method = clazz.getMethod("getDesktop", new Class[0]);
            Object desktop = method.invoke(null, new Object[0]);
            method = clazz.getMethod("open", File.class);
            method.invoke(desktop, file);
            logger.finer("Desktop \u304b\u3089\u306e\u8d77\u52d5\u306b\u6210\u529f\u3057\u307e\u3057\u305f: " + file);
            return true;
        }
        catch (Exception ex) {
            logger.finer("JSE 6 Desktop \u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093: " + ex);
            return false;
        }
    }

    public boolean openURL(String url) {
        return false;
    }

    public String getDefaultRepository() {
        return System.getProperty("user.home", ".") + File.separator + "Jive2ch";
    }

    private static Platform createPlatform() {
        Platform platform = new Platform();
        String osname = System.getProperty("os.name");
        ResourceBundle res = ResourceBundle.getBundle("org.koiroha.jive2ch.platform");
        Enumeration<String> en = res.getKeys();
        while (en.hasMoreElements()) {
            String regex = en.nextElement();
            if (!osname.matches(regex)) continue;
            String className = res.getString(regex);
            try {
                platform = (Platform)Class.forName(className).newInstance();
                break;
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Platform\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u69cb\u7bc9\u306b\u5931\u6557: " + className, ex);
            }
        }
        logger.fine("\u30d7\u30e9\u30c3\u30c8\u30d5\u30a9\u30fc\u30e0: " + platform.getClass().getCanonicalName());
        return platform;
    }

    public static enum OS {
        WINDOWS,
        MACOSX,
        UNKNOWN;

    }
}

