/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.apple.eio.FileManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.koiroha.jive2ch.Platform;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.Jive2chFrame;

public class MacOSX
extends Platform {
    private static final Logger logger = Logger.getLogger(MacOSX.class.getName());

    @Override
    public String getDefaultRepository() {
        return System.getProperty("user.home", ".") + File.separator + "Library" + File.separator + "Jive2ch";
    }

    @Override
    public void setApplicationWindow(final Jive2chFrame frame) {
        Application app = Application.getApplication();
        app.addAboutMenuItem();
        app.addPreferencesMenuItem();
        app.setEnabledAboutMenu(true);
        app.setEnabledPreferencesMenu(true);
        app.addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void handleAbout(ApplicationEvent e) {
                e.setHandled(true);
                frame.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        frame.showAbout();
                    }
                });
            }
        });
        app.addApplicationListener((ApplicationListener)GUI.wrapSWTInvoke(new ApplicationAdapter(){

            public void handlePreferences(ApplicationEvent e) {
                frame.showPreference();
            }

            public void handleQuit(ApplicationEvent e) {
                frame.exit();
            }
        }, ApplicationListener.class));
    }

    @Override
    public boolean openURL(String url) {
        try {
            FileManager.openURL((String)url);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "URL\u306e\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + url, ex);
        }
        return true;
    }

    @Override
    protected String getModifierKeyString(int key) {
        switch (key) {
            case 0x400000: {
                return "\u2318";
            }
            case 131072: {
                return "\u21e7";
            }
        }
        return super.getModifierKeyString(key);
    }

    @Override
    public String getKeyStrokeLabel(int keyStroke) {
        List<String> meta = this.getMetaKeyLabel(keyStroke & SWT.MODIFIER_MASK);
        if (meta.size() > 0) {
            meta.add("+");
        }
        meta.add(String.valueOf((char)keyStroke & 0xFFFF));
        StringBuilder buffer = new StringBuilder();
        for (String k : meta) {
            buffer.append(k);
        }
        return buffer.toString();
    }

    @Override
    public Platform.OS getOS() {
        return Platform.OS.MACOSX;
    }

    @Override
    protected int getMenuAccelaraterModifier() {
        return 0x400000;
    }
}

