/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch;

import java.awt.Dimension;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.eclipse.swt.widgets.Display;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.Category;
import org.koiroha.jive2ch.Config;
import org.koiroha.jive2ch.Platform;
import org.koiroha.jive2ch.Repository;
import org.koiroha.jive2ch.RepositoryLockException;
import org.koiroha.jive2ch.Resource;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.func.FavouriteCategory;
import org.koiroha.jive2ch.func.LocalBoard;
import org.koiroha.jive2ch.func.SkinManager;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.gui.Jive2chFrame;
import org.koiroha.jive2ch.gui.Scrap;
import org.koiroha.jive2ch.util.AADB;
import org.koiroha.jive2ch.util.J2Formatter;
import org.koiroha.jive2ch.worker.Launcher;

public class Jive2ch
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(Jive2ch.class.getName());
    public static final String APP_NAME = "Jive2ch";
    public static final String APP_VER;
    public static final String APP_SUBVER;
    public static final String APP_BUILD;
    private static Jive2ch DEFAULT;
    public final Resource res = new Resource();
    public final Config config = Config.getDefault();
    public final Scrap scrap;
    public final Repository repository;
    public final SkinManager skin;
    public final AADB aadb;
    public final Category appCategory;
    public final FavouriteCategory favourite;
    private List<Category> categories;
    private final PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);

    public Jive2ch(File dir) throws IOException {
        if (DEFAULT == null) {
            DEFAULT = this;
        }
        this.repository = new Repository(dir);
        this.categories = this.repository.readCategories(this);
        this.skin = this.repository.createSkinManager();
        this.aadb = this.repository.createAADB();
        this.scrap = this.repository.createScrap();
        this.appCategory = new Category(this, APP_NAME);
        this.appCategory.setCollapseIcon(GUI.ICON_APP16);
        this.appCategory.setExpandIcon(GUI.ICON_APP16);
        LocalBoard local = new LocalBoard(this.appCategory, "\u6700\u8fd1\u8aad\u307f\u8fbc\u3093\u3060\u30b9\u30ec\u30c3\u30c9", "recentread");
        local.setCascadeDelete(true);
        this.appCategory.addBoard("recentRead", local);
        local = new LocalBoard(this.appCategory, "\u6700\u8fd1\u66f8\u304d\u8fbc\u3093\u3060\u30b9\u30ec\u30c3\u30c9", "recentwrite");
        local.setCascadeDelete(true);
        this.appCategory.addBoard("recentWrite", local);
        this.favourite = new FavouriteCategory(this);
        SkinManager.setDefault(this.skin);
    }

    public static Jive2ch getDefault() {
        assert (DEFAULT != null);
        return DEFAULT;
    }

    public Thread getThreadByLocalFile(File file) throws IOException {
        file = file.getCanonicalFile();
        for (Category cat : this.getCategoryList()) {
            for (Board b : cat.getBoards()) {
                File dir = b.getDirectory().getCanonicalFile();
                if (!file.toString().startsWith(dir.toString())) continue;
                Thread thread = b.getService().createThread(b, file.getName(), null, 0);
                thread.charge();
                return thread;
            }
        }
        logger.fine("dat \u30d5\u30a1\u30a4\u30eb\u306b\u5bfe\u3059\u308b\u63b2\u793a\u677f\u304c\u5b58\u5728\u3057\u307e\u305b\u3093: " + file);
        return null;
    }

    public Board getBoardByURI(URI uri) throws IOException {
        for (Category cat : this.getCategoryList()) {
            for (Board b : cat.getBoards()) {
                URI rel = b.getURI().relativize(uri);
                if (rel.isAbsolute()) continue;
                return b;
            }
        }
        logger.fine("URI \u306b\u5bfe\u3059\u308b\u63b2\u793a\u677f\u304c\u5b58\u5728\u3057\u307e\u305b\u3093: " + uri);
        return null;
    }

    public LocalBoard getRecentReadBoard() {
        return this.appCategory.getBoard("recentRead");
    }

    public LocalBoard getRecentWriteBoard() {
        return this.appCategory.getBoard("recentWrite");
    }

    public void dispose() {
        logger.finer("dispose()");
        this.config.flush();
        this.scrap.flush();
        this.repository.close();
        if (DEFAULT == this) {
            DEFAULT = null;
        }
        logger.fine("\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f");
    }

    public List<Category> getCategoryList() {
        ArrayList<Category> cat = new ArrayList<Category>();
        cat.add(this.appCategory);
        cat.add(this.favourite);
        cat.addAll(this.categories);
        return cat;
    }

    public void reloadCategoryList() throws IOException {
        this.categories = this.repository.readCategories(this);
    }

    public void addDispatchListner(PropertyChangeListener l) {
        this.propertyChange.addPropertyChangeListener(l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.propertyChange.firePropertyChange(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String repository = Platform.getPlatform().getDefaultRepository();
        Level level = Level.INFO;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--repository") && i + 1 < args.length) {
                repository = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("--verbose")) {
                level = Level.ALL;
                continue;
            }
            System.err.println("ERROR: \u4e0d\u660e\u306a\u30aa\u30d7\u30b7\u30e7\u30f3: " + args[i]);
            System.exit(1);
        }
        Logger root = Logger.getLogger("");
        root.setLevel(level);
        for (Handler h : root.getHandlers()) {
            root.removeHandler(h);
        }
        ConsoleHandler h = new ConsoleHandler();
        h.setLevel(level);
        h.setFormatter(new J2Formatter());
        try {
            Display.setAppName(APP_NAME);
            Display.getDefault();
        }
        catch (Throwable ex) {
            if (ex instanceof ThreadDeath) {
                throw (ThreadDeath)ex;
            }
            ex.printStackTrace();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            JTextArea desc = new JTextArea();
            desc.setText(sw.toString());
            desc.setFont(desc.getFont().deriveFont(11.0f));
            desc.setEditable(false);
            desc.setTabSize(4);
            desc.setCaretPosition(0);
            JScrollPane scroll = new JScrollPane(desc);
            scroll.setPreferredSize(new Dimension(400, 150));
            Jive2ch.systemFatal(scroll);
            return;
        }
        Jive2ch app = null;
        try {
            try {
                File dir = new File(repository).getCanonicalFile();
                app = new Jive2ch(dir);
                Jive2chFrame frame = new Jive2chFrame();
                Platform.getPlatform().setApplicationWindow(frame);
                frame.open();
            }
            catch (RepositoryLockException ex) {
                J2Component.error("\u4ed6\u306e Jive2ch \u304c\u5b9f\u884c\u4e2d\u3067\u3059", ex);
            }
            catch (Throwable ex) {
                if (ex instanceof ThreadDeath) {
                    throw (ThreadDeath)ex;
                }
                J2Component.fatal(ex);
            }
            finally {
                if (app != null) {
                    app.dispose();
                }
                Launcher.dispose();
            }
        }
        catch (Throwable ex) {
            if (ex instanceof ThreadDeath) {
                throw (ThreadDeath)ex;
            }
            ex.printStackTrace();
            System.exit(1);
        }
        Frame[] frame = Frame.getFrames();
        for (int i = 0; frame != null && i < frame.length; ++i) {
            frame[i].dispose();
        }
        logger.info("Jive2ch " + APP_VER + "." + APP_SUBVER + "_" + APP_BUILD + "\u3092\u7d42\u4e86\u3057\u307e\u3059");
        System.exit(0);
    }

    private static void systemFatal(final Object msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, msg, "Fatal Error", 0);
                System.exit(1);
            }
        });
    }

    static {
        DEFAULT = null;
        ResourceBundle res = ResourceBundle.getBundle("org.koiroha.jive2ch.version");
        APP_VER = res.getString("version");
        APP_SUBVER = res.getString("subversion");
        APP_BUILD = res.getString("build");
    }
}

