/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.util.IO;
import org.koiroha.jive2ch.util.MetaInfoListener;
import org.koiroha.jive2ch.util.MetaInfoSupport;
import org.koiroha.jive2ch.util.RollbackOutputStream;

public class J2Bean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(J2Bean.class.getName());
    private static final String META_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    private Map<String, String> meta = null;
    private boolean metaModified = false;
    private File metaFile = null;
    private final PropertyChangeSupport propListener = new PropertyChangeSupport(this);
    private final MetaInfoSupport listener = new MetaInfoSupport(this);

    protected void setMetaFile(File file) {
        this.metaFile = file;
        this.meta = null;
    }

    protected File getMetaFile() {
        return this.metaFile;
    }

    protected synchronized void clearMetaInfo() {
        this.meta = null;
        this.metaModified = false;
    }

    protected void deleteMetaFile() throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("deleteMetaFile(): " + this.metaFile);
        }
        IO.delete(this.metaFile);
    }

    protected String getMetaInfo(String name) {
        this.loadMetaInfo();
        if (this.meta == null) {
            return null;
        }
        return this.meta.get(name);
    }

    protected int getMetaInfo(String name, int def) {
        String num = this.getMetaInfo(name);
        if (num == null) {
            return def;
        }
        return Integer.parseInt(num);
    }

    protected long getMetaInfo(String name, long def) {
        String num = this.getMetaInfo(name);
        if (num == null) {
            return def;
        }
        return Long.parseLong(num);
    }

    protected Date getMetaInfo(String name, Date def) {
        String date = this.getMetaInfo(name);
        if (date == null) {
            return def;
        }
        try {
            return new SimpleDateFormat(META_DATE_FORMAT).parse(date);
        }
        catch (ParseException ex) {
            logger.warning("\u30b9\u30ec\u30c3\u30c9 " + this.metaFile + " \u306e\u30e1\u30bf\u60c5\u5831\u306b\u7121\u52b9\u306a\u65e5\u4ed8\u3092\u691c\u51fa\u3057\u307e\u3057\u305f: " + name + "=" + date);
            return def;
        }
    }

    protected void setMetaInfo(String name, String value) {
        this.loadMetaInfo();
        if (this.meta == null) {
            this.meta = new HashMap<String, String>();
        }
        this.meta.put(name, value);
        this.metaModified = true;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("\u30e1\u30bf\u60c5\u5831: " + name + "=" + value);
        }
    }

    protected void setMetaInfo(String name, long value) {
        this.setMetaInfo(name, String.valueOf(value));
    }

    protected void setMetaInfo(String name, Date value) {
        this.setMetaInfo(name, new SimpleDateFormat(META_DATE_FORMAT).format(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMetaInfo() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("saveMetaInfo(): " + this.metaFile);
        }
        if (!this.metaModified) {
            logger.finest("\u30e1\u30bf\u60c5\u5831\u306f\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            return;
        }
        if (this.meta != null) {
            BufferedOutputStream out = null;
            try {
                out = new BufferedOutputStream(new RollbackOutputStream(this.metaFile));
                Properties prop = new Properties();
                prop.putAll(this.meta);
                prop.store(out, "meta information");
                IO.close(out);
            }
            catch (IOException ex) {
                J2Component.fatal(ex);
            }
            finally {
                IO.close(out);
            }
            this.metaModified = false;
        }
        logger.finer("\u30e1\u30bf\u60c5\u5831\u3092\u4fdd\u5b58\u3057\u307e\u3057\u305f: " + this.metaFile.getName());
        this.listener.fireModifyCommitted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadMetaInfo() {
        Properties prop;
        block9: {
            if (this.meta != null || this.metaFile == null || !this.metaFile.isFile()) {
                return;
            }
            prop = new Properties();
            BufferedInputStream in = null;
            try {
                int size = (int)Math.max(Math.min(this.metaFile.length(), 4096L), 1L);
                in = new BufferedInputStream(new FileInputStream(this.metaFile), size);
                prop.load(in);
                IO.close(in);
            }
            catch (FileNotFoundException ex) {
                IO.close(in);
            }
            catch (IOException ex2) {
                logger.warning("\u30e1\u30bf\u60c5\u5831\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + this.metaFile);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IO.close(in);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : prop.entrySet()) {
            map.put((String)e.getKey(), (String)e.getValue());
        }
        this.meta = map;
        this.metaModified = false;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propListener.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propListener.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("\u30d7\u30ed\u30d1\u30c6\u30a3\u5909\u66f4\u901a\u77e5: " + propertyName + ": " + oldValue + " -> " + newValue);
        }
        this.propListener.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addMetaInfoListener(MetaInfoListener l) {
        this.listener.addMetaInfoListener(l);
    }

    public void removeMetaInfoListener(MetaInfoListener l) {
        this.listener.removeMetaInfoListener(l);
    }
}

