/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch;

import java.io.File;
import java.util.logging.Logger;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.koiroha.jive2ch.J2Bean;
import org.koiroha.jive2ch.gui.GUI;

public class Icon
extends J2Bean {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Icon.class.getName());
    private final File icon;
    private Image image = null;

    public Icon(File icon) {
        this(icon, null);
    }

    public Icon(File icon, Image image) {
        this.icon = icon;
        this.image = image != null ? image : Icon.load(icon);
    }

    public File getFile() {
        return this.icon;
    }

    public Image getImage() {
        return this.image;
    }

    public Image getImage(int size) {
        return GUI.getScaledImage(this.image, size);
    }

    private static Image load(File icon) {
        if (icon.isFile() && icon.length() > 0L) {
            try {
                return new Image((Device)Display.getDefault(), icon.toString());
            }
            catch (SWTException ex) {
                logger.finer("\u30a2\u30a4\u30b3\u30f3\u3092\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f: " + icon + "; " + ex);
            }
        }
        return null;
    }
}

