/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.koiroha.jive2ch.Jive2ch;
import org.koiroha.jive2ch.Response;
import org.koiroha.jive2ch.client.UserAgent;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.gui.J2Component;
import org.koiroha.jive2ch.util.NGWord;

public class Config {
    private static final Logger logger = Logger.getLogger(Config.class.getName());
    private static final Config CONFIG = new Config();
    private final Preferences pref = Preferences.userNodeForPackage(Jive2ch.class);
    private List<NGWord> ngwords = null;
    private final PropertyChangeSupport listener = new PropertyChangeSupport(this);

    private Config() {
    }

    public static Config getDefault() {
        return CONFIG;
    }

    public File getExportDirectory() {
        return new File(this.pref.get("dir.export", System.getProperty("user.home", ".")));
    }

    public void setExportDirectory(File dir) {
        this.pref.put("dir.export", dir.getAbsolutePath());
    }

    public String getUserAgent() {
        return this.pref.get("network.http.userAgent", UserAgent.DEFAULT_USER_AGENT);
    }

    public void setUserAgent(String userAgent) {
        this.set("network.http.userAgent", userAgent);
    }

    public int getConnectionTimeout() {
        return this.pref.getInt("network.http.connectionTimeout", 5000);
    }

    public void setConnectionTimeout(int timeout) {
        this.set("network.http.connectionTimeout", timeout);
    }

    public int getReadTimeout() {
        return this.pref.getInt("network.http.readTimeout", 20000);
    }

    public void setReadTimeout(int timeout) {
        this.set("network.http.readTimeout", timeout);
    }

    public boolean isOfflineMode() {
        return this.pref.getBoolean("network.offline", false);
    }

    public void setOfflineMode(boolean offline) {
        Boolean oldValue = this.isOfflineMode();
        Boolean newValue = offline;
        this.set("network.offline", offline);
        this.firePropertyChange("offlineMode", oldValue, newValue);
    }

    public String getSkinName() {
        return this.pref.get("thread.skin", "default");
    }

    public void setSkinName(String skin) {
        this.set("thread.skin", skin);
    }

    public GUI.FontSize getTheadFontSize() {
        String name = this.pref.get("thread.fontSize", GUI.FontSize.MEDIUM.name());
        try {
            return GUI.FontSize.valueOf(name);
        }
        catch (IllegalArgumentException ex) {
            return GUI.FontSize.MEDIUM;
        }
    }

    public void setThreadFontSize(GUI.FontSize size) {
        this.set("thread.fontSize", size.name());
    }

    public GUI.FontSize getWindowFontSize() {
        String name = this.pref.get("window.fontSize", GUI.FontSize.MEDIUM.name());
        try {
            return GUI.FontSize.valueOf(name);
        }
        catch (IllegalArgumentException ex) {
            return GUI.FontSize.MEDIUM;
        }
    }

    public void setWindowFontSize(GUI.FontSize size) {
        this.set("window.fontSize", size.name());
    }

    public long getPopupInterval() {
        return this.pref.getLong("thread.popupInterval", 400L);
    }

    public void setPopupInterval(long interval) {
        this.set("thread.popupInterval", interval);
    }

    public List<NGWord> getNGWords() {
        if (this.ngwords == null) {
            File file = Jive2ch.getDefault().repository.ngWordFile;
            try {
                this.ngwords = NGWord.load(file);
            }
            catch (IOException ex) {
                J2Component.fatal(ex);
            }
        }
        return this.ngwords;
    }

    public void setNGWords(List<NGWord> list) {
        this.ngwords = list;
        logger.finest("NG\u30ef\u30fc\u30c9: " + list);
    }

    public void setNGWordEnabled(boolean enabled) {
        this.pref.putBoolean("ngWord", enabled);
    }

    public boolean isNGWordEnabled() {
        return this.pref.getBoolean("ngWord", true);
    }

    public boolean isNG(Response res) {
        List<NGWord> list = this.getNGWords();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).isNG(res)) continue;
            return true;
        }
        return false;
    }

    public void setThumbnailEnabled(boolean enabled) {
        this.pref.putBoolean("thumbnail", enabled);
    }

    public boolean isThumbnailEnabled() {
        return this.pref.getBoolean("thumbnail", true);
    }

    public boolean isTransparentAbone() {
        return this.pref.getBoolean("ngWord.transparent", false);
    }

    public void setTransparentAbone(boolean trans) {
        this.pref.putBoolean("ngWord.transparent", trans);
    }

    private void set(String name, String value) {
        String oldValue = this.pref.get(name, null);
        String newValue = value;
        this.pref.put(name, value);
        this.firePropertyChange(name, oldValue, newValue);
    }

    private void set(String name, int value) {
        Integer oldValue = this.pref.getInt(name, 0);
        Integer newValue = value;
        this.pref.putInt(name, value);
        this.firePropertyChange(name, oldValue, newValue);
    }

    private void set(String name, long value) {
        Long oldValue = this.pref.getLong(name, 0L);
        Long newValue = value;
        this.pref.putLong(name, value);
        this.firePropertyChange(name, oldValue, newValue);
    }

    private void set(String name, boolean value) {
        Boolean oldValue = this.pref.getBoolean(name, false);
        Boolean newValue = value;
        this.pref.putBoolean(name, value);
        this.firePropertyChange(name, oldValue, newValue);
    }

    public void flush() {
        try {
            this.pref.flush();
        }
        catch (BackingStoreException ex) {
            logger.log(Level.WARNING, "\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u8a2d\u5b9a\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
        }
        if (this.ngwords != null) {
            File file = Jive2ch.getDefault().repository.ngWordFile;
            try {
                NGWord.store(file, this.ngwords);
            }
            catch (IOException ex) {
                J2Component.fatal(ex);
            }
        }
    }

    public void publish() {
        UserAgent ua = UserAgent.getDefault();
        ua.setConnectionTimeout(this.getConnectionTimeout());
        ua.setReadTimeout(this.getReadTimeout());
        ua.setUserAgent(this.getUserAgent());
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener.removePropertyChangeListener(l);
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        logger.finest("\u8a2d\u5b9a\u5024\u5909\u66f4: " + propertyName + ": " + oldValue + " -> " + newValue);
        this.listener.firePropertyChange(propertyName, oldValue, newValue);
    }
}

