/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.swt.graphics.Image;
import org.koiroha.jive2ch.Board;
import org.koiroha.jive2ch.J2Bean;
import org.koiroha.jive2ch.Jive2ch;
import org.koiroha.jive2ch.func.LocalBoard;
import org.koiroha.jive2ch.func.Service;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.xml.parser.HTMLDocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Category
extends J2Bean {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Category.class.getName());
    private final Jive2ch app;
    private final String name;
    private final List<Board> board = new ArrayList<Board>();
    private Map<String, Integer> namedIndex = null;
    private Image collapseIcon = GUI.ICON_CATEGORY_COLLAPSE;
    private Image expandIcon = GUI.ICON_CATEGORY_EXPAND;

    public Category(Jive2ch app, String name) {
        this.app = app;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Image getCollapseIcon() {
        return this.collapseIcon;
    }

    public void setCollapseIcon(Image collapseIcon) {
        this.collapseIcon = collapseIcon;
    }

    public Image getExpandIcon() {
        return this.expandIcon;
    }

    public void setExpandIcon(Image expandIcon) {
        this.expandIcon = expandIcon;
    }

    public Jive2ch getJive2ch() {
        return this.app;
    }

    public List<Board> getBoards() {
        return Collections.unmodifiableList(this.board);
    }

    public int addBoard(Board board) {
        this.board.add(board);
        return this.board.size() - 1;
    }

    public void removeBoard(Board board) {
        int index = -1;
        for (int i = 0; i < this.board.size(); ++i) {
            if (this.board.get(i) != board) continue;
            index = i;
            break;
        }
        assert (index >= 0) : "\u524a\u9664\u5bfe\u8c61\u306e\u63b2\u793a\u677f\u304c\u898b\u4ed8\u304b\u308a\u307e\u305b\u3093";
        this.board.remove(index);
        if (this.namedIndex != null) {
            for (Map.Entry<String, Integer> e : this.namedIndex.entrySet()) {
                if (e.getValue() == index) {
                    e.setValue(null);
                    continue;
                }
                if (e.getValue() <= index) continue;
                e.setValue(e.getValue() - 1);
            }
        }
        logger.finer("\u63b2\u793a\u677f\u3092\u30ab\u30c6\u30b4\u30ea\u304b\u3089\u9664\u53bb\u3057\u307e\u3057\u305f: " + board.getName());
    }

    public int addBoard(String name, LocalBoard board) {
        int index = this.addBoard(board);
        if (this.namedIndex == null) {
            this.namedIndex = new HashMap<String, Integer>();
        }
        this.namedIndex.put(name, index);
        return index;
    }

    public LocalBoard getBoard(String name) {
        if (this.namedIndex == null || !this.namedIndex.containsKey(name)) {
            throw new NoSuchElementException(name);
        }
        return (LocalBoard)this.board.get(this.namedIndex.get(name));
    }

    public String toString() {
        return this.getName();
    }

    public static List<Category> parse(Jive2ch app, InputStream in, String defEnc) throws IOException {
        logger.fine("BBS\u30e1\u30cb\u30e5\u30fc\u3092\u89e3\u6790\u3057\u3066\u3044\u307e\u3059...");
        Document html = null;
        try {
            HTMLDocumentBuilderFactory f = new HTMLDocumentBuilderFactory();
            InputSource is = f.guessInpuSource(in, defEnc, 4096);
            DocumentBuilder b = f.newDocumentBuilder();
            html = b.parse(is);
            ArrayList<Category> list = new ArrayList<Category>();
            Category cat = null;
            String expr = "/html/body/font/*[local-name()='a' or local-name()='b']";
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nl = (NodeList)xpath.evaluate(expr, html, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                Board board;
                Element elem = (Element)nl.item(i);
                if (elem.getTagName().equals("b")) {
                    String name = elem.getTextContent().trim();
                    cat = new Category(app, name);
                    list.add(cat);
                    continue;
                }
                if (cat == null || (board = Category.create(cat, elem)) == null) continue;
                cat.addBoard(board);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("\u30ab\u30c6\u30b4\u30ea\u4e00\u89a7\u306e\u89e3\u6790\u5b8c\u4e86: " + ((Object)list).toString());
            }
            return list;
        }
        catch (SAXException ex) {
            throw new IOException(ex.toString());
        }
        catch (XPathException ex) {
            throw new IllegalStateException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Board create(Category cat, Element elem) throws IOException {
        try {
            URI uri = new URI(elem.getAttribute("href"));
            Service service = Service.getService(uri);
            if (service == null) {
                return null;
            }
            String name = elem.getTextContent().trim();
            return service.createBoard(cat, name, uri);
        }
        catch (URISyntaxException ex) {
            logger.finer("\u6709\u52b9\u306a\u63b2\u793a\u677fURI\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3067\u3057\u305f: " + ex);
            return null;
        }
    }
}

