/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.jive2ch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.koiroha.jive2ch.Category;
import org.koiroha.jive2ch.Icon;
import org.koiroha.jive2ch.J2Bean;
import org.koiroha.jive2ch.Thread;
import org.koiroha.jive2ch.func.Service;
import org.koiroha.jive2ch.gui.GUI;
import org.koiroha.jive2ch.util.IO;

public class Board
extends J2Bean {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Board.class.getName());
    public static final Icon DEFAULT_ICON = new Icon(new File("defaulticon.$$$"), GUI.ICON_DEFAULT_BOARD);
    private static Map<String, Icon> DEFAULT_ICONS = new HashMap<String, Icon>();
    private final Service service;
    private final File dir;
    private final Category category;
    private final String name;
    private final URI uri;
    private Icon icon = null;
    private Properties settings = null;

    public Board(Service service, Category category, String name, URI uri) {
        this(service, category, name, uri, category.getJive2ch().repository.getBoardDirectory(uri));
    }

    protected Board(Service service, Category category, String name, File dir) {
        this(service, category, name, dir.toURI(), dir);
    }

    private Board(Service service, Category category, String name, URI uri, File dir) {
        this.service = service;
        this.category = category;
        this.name = name;
        this.uri = uri;
        this.dir = dir;
        try {
            IO.mkdir(dir);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "\u63b2\u793a\u677f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + dir, ex);
        }
        this.setMetaFile(new File(dir.getParentFile(), "." + dir.getName()));
        this.resetIcon();
    }

    public Service getService() {
        return this.service;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public URI getURI() {
        return this.uri;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        if (icon == null) {
            icon = DEFAULT_ICON;
        }
        Icon oldValue = this.icon;
        Icon newValue = icon;
        this.icon = icon;
        this.firePropertyChange("icon", oldValue, newValue);
    }

    public void resetIcon() {
        File icon = this.getCustomIconFile();
        if (icon.isFile()) {
            this.setIcon(new Icon(icon));
            return;
        }
        icon = this.getDefaultIconFile();
        if (icon.isFile()) {
            Icon i = DEFAULT_ICONS.get(icon.toString());
            if (i == null) {
                i = new Icon(icon);
                DEFAULT_ICONS.put(icon.toString(), i);
            }
            this.setIcon(i);
            return;
        }
        this.setIcon(null);
    }

    public File getDirectory() {
        return this.dir;
    }

    public File getCustomIconFile() {
        return new File(this.dir, "icon.png");
    }

    public File getDefaultIconFile() {
        URI uri = this.getURI();
        File dir = this.getCategory().getJive2ch().repository.getServerDirectory(uri);
        return new File(dir, "favicon.ico");
    }

    public File getSettingFile() {
        return new File(this.getDirectory(), "SETTING.TXT");
    }

    public Thread parse(String line) throws IOException {
        return this.getService().parseSubject(this, line);
    }

    public boolean sameAs(Board other) {
        return this.getURI().equals(other.getURI());
    }

    public void setSettings(Properties settings) {
        Properties oldValue = this.settings;
        Properties newValue = settings;
        this.settings = settings;
        this.firePropertyChange("settings", oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getSettings() {
        block5: {
            if (this.settings != null) break block5;
            File file = this.getSettingFile();
            Properties prop = new Properties();
            BufferedReader in = null;
            try {
                String line;
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), IO.SJIS));
                while ((line = in.readLine()) != null) {
                    int sep = line.indexOf(61);
                    if (sep < 0) continue;
                    String name = line.substring(0, sep).trim();
                    String value = line.substring(sep + 1).trim();
                    prop.setProperty(name, value);
                }
            }
            catch (IOException ex) {
                try {
                    logger.fine("\u30ed\u30fc\u30ab\u30eb\u306e\u63b2\u793a\u677f\u8a2d\u5b9a\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f: " + file + ": " + ex);
                }
                catch (Throwable throwable) {
                    IO.close(in);
                    throw throwable;
                }
                IO.close(in);
            }
            IO.close(in);
            this.settings = prop;
        }
        return this.settings;
    }

    public File getSubjectFile() {
        return new File(this.getDirectory(), "subject.txt");
    }

    public Date getContributeDate() {
        return this.getMetaInfo("contribute.date", null);
    }

    public void setContributeDate(Date date) {
        this.setMetaInfo("contribute.date", date);
    }

    public long getContributeInterval() {
        return this.getMetaInfo("contribute.interval", 0L);
    }

    public void setContributeInterval(long interval) {
        this.setMetaInfo("contribute.interval", interval);
    }
}

