#ifndef _LINUX_KMEMPROF_H
#define _LINUX_KMEMPROF_H

enum kmemprof_event_type {
	KMEM_ALLOC,
	KMEM_FREE
};

#ifdef __KERNEL__

#include <linux/config.h>
#include <linux/notifier.h>
#include <linux/slab.h>


struct kmemprof_event {
	enum kmemprof_event_type type;
	kmem_cache_t * cache;
	int flags;	/* it is significant in case of type == KMEM_ALLOC */
	void * obj;
	void * frame;
	void * eip;
};

extern void kmemprof_notifier_call_chain (enum kmemprof_event_type type,
					struct kmemprof_event * event);
extern int kmemprof_notifier_chain_register(struct notifier_block * nb);
extern int kmemprof_notifier_chain_unregister(struct notifier_block * nb);

#endif /* __KERNEL__ */

#endif /* _LINUX_KMEMPROF_H */

