#ifndef _RINGBUF_H
#define _RINGBUF_H

#include <linux/fs.h>
#include <linux/kmemprof.h>

struct ringbuf_entry {
	char data;
};

struct ringbuf {
	volatile unsigned long head_pos;
	volatile unsigned long tail_pos;
	unsigned long buf_size;
	struct ringbuf_entry * buf;
	unsigned long received;
	unsigned long lost_overflow;
};

extern int ringbuf_init(struct ringbuf *desc, unsigned long buf_size);
extern void ringbuf_destroy(struct ringbuf *desc);
extern int ringbuf_write (struct ringbuf * desc,
		struct ringbuf_entry * entries, unsigned long count);
extern int ringbuf_read_user (struct ringbuf * desc,
		struct ringbuf_entry * entries, unsigned long count);
void ringbuf_reset(struct ringbuf *desc);

#endif /* _RINGBUF_H */

