
require 'lsmod'
require 'nm'
require 'getoptlong'

ksyms_file = '/proc/ksyms'
system_map = '/boot/System.map'
prof_shift = 2

opts = GetoptLong.new(
  [ "--ksyms", "-k", GetoptLong::REQUIRED_ARGUMENT],
  [ "--system-map", "-s", GetoptLong::REQUIRED_ARGUMENT],
  [ "--profile-shift", "-p", GetoptLong::REQUIRED_ARGUMENT]
  )

opts.each do |opt, arg|
  ksyms_file = arg.to_s if opt == "--ksyms"
  system_map = arg.to_s if opt == "--system-map"
  prof_shift = arg.to_i if opt == "--profile-shift"
end

all_modinfo = Proc_Ksyms_Reader.All_KMod_Load_Info(ksyms_file)
vmlinux_syms = NM_Reader.All_Syms_File(system_map)

regions = []

stext = 0
etext = 0

vmlinux_syms.each do |sym|
  stext = sym.value if sym.name == '_stext'
  etext = sym.value if sym.name == '_etext'
end

regions.push([stext, etext - stext])

all_modinfo.each_value do |modinfo|
  text_section = modinfo.get_section('.text')
  regions.push(text_section) if text_section != nil
end

regions.sort!{|x,y| x[0] <=> y[0]}

offset_parm = "region_offset=" + regions.collect {|x| x[0]}.join(",")
size_parm = "region_size=" + regions.collect {|x| x[1]}.join(",")
shift_parm = "region_shift" + ([prof_shift]*regions.length).join(",")

comm_args = [offset_parm, size_parm, shift_parm].join(" ")
puts (comm_args)

