"""Widgets inheriting from Qt widgets"""

from qt import *
from Queue import Queue

from utils import *


class KittyTabWidget(QTabWidget):
    def __init__(self, parent=None):
        QTabWidget.__init__(self, parent)
        self.setTabBar(KittyTabBar(self))
        self._tab_menu = self._TabMenu(self)
        self._newtab = True
        self._model_view_registry = self._ModelViewRegistry()
        self._queue = Queue()
        self._timer = QTimer()
        self.connect(self._timer, SIGNAL("timeout()"), self._reduce_queue)
        self._timer.start(100, False)

    def _reduce_queue(self):
        if not self._queue.empty():
            self._display(*self._queue.get())

    def _display(self, *args):
        """Actually display

        This method must be inherited.
        """
        pass

    class _TabMenu(QPopupMenu):
        def __init__(self, parent):
            QPopupMenu.__init__(self, parent)
            self._taget_widget = None
            self.insertItem(u("更新"), self._reload)
            self.insertSeparator()
            self.insertItem(u("閉じる"), self._close)

        def popup(self, widget, position):
            self._target_widget = widget
            QPopupMenu.popup(self, position)

        def _reload(self):
            self.emit(PYSIGNAL("requestReload"), (self._target_widget,))

        def _close(self):
            self.emit(PYSIGNAL("requestClose"), (self._target_widget,))

    class _ModelViewRegistry(dict):
        """Stores Model and View relations"""
        # This is a dictionary that key is model and value is view.

        def views(self):
            """Return list of views"""
            return self.values()

        def models(self):
            """Return list of models"""
            return self.keys()

        def has_model(self, model):
            """Return whether model is contained"""
            return self.has_key(model)

        def view(self, model):
            """Return view associated with model"""
            return self[model]

        def model(self, view):
            """Return model associated with view"""
            d = dict([(v,m) for (m,v) in self.items()])
            return d.get(view, None)

        def size(self):
            return len(self)

        def set(self, model, view):
            self[model] = view

        def remove(self, view):
            """Remove view"""
            del self[self.model(view)]


class KittyTabBar(QTabBar):
    """TabBar subclass

    KittyTabBar is subclass of QTabBar with few extensions.  This class 
    provides tabRightPressed() and similar PYSIGNAL's.  This wheel was 
    invented to use Qt2.3, while you don't need this class with Qt3.
    """

    def __init__(self, parent):
        QTabBar.__init__(self, parent)
        self._parent = parent

    def mousePressEvent(self, event):
        if event.button()==Qt.LeftButton:
            QTabBar.mousePressEvent(self, event)
        elif event.button()==Qt.RightButton:
            self._parent.emit(PYSIGNAL("tabRightPressed"),
                              (self.pointedPage(event),
                               self.mapToGlobal(event.pos())))
        elif event.button()==Qt.MidButton:
            self._parent.emit(PYSIGNAL("tabMidPressed"),
                              (self.pointedPage(event),
                               self.mapToGlobal(event.pos())))

    def mouseDoubleClickEvent(self, event):
        if event.button()==Qt.LeftButton:
            self._parent.emit(PYSIGNAL("tabLeftDoubleClicked"),
                              (self.pointedPage(event),
                               self.mapToGlobal(event.pos())))
        elif event.button()==Qt.RightButton:
            self._parent.emit(PYSIGNAL("tabRightDoubleClicked"),
                              (self.pointedPage(event),
                               self.mapToGlobal(event.pos())))
        elif event.button()==Qt.MidButton:
            self._parent.emit(PYSIGNAL("tabMidDoubleClicked"),
                              (self.pointedPage(event),
                               self.mapToGlobal(event.pos())))

    def pointedPage(self, event):
        current_id = self.currentTab()
        tab = self.selectTab(event.pos())
        self.setCurrentTab(tab)
        page = self._parent.currentPage()
        self.setCurrentTab(current_id)
        return page

