# -*- coding: utf8 -*-
"""Kittywalk application"""

from utils import *
from bbs import *
import Logger


class Application(object):
    """KittyWalk application

    This class handles critical works except user interface tasks.
    """

    def __init__(self, UserInterfaceClass):
        self._ui = UserInterfaceClass(self)
        self._bbs = BBS()

    def start(self):
        """Start KittyWalk application"""
        Logger.log("Application started.")
        self._ui.start()
        Logger.log("Application quit.")

    def bbs(self):
        """Return BBS instance"""
        return self._bbs

    def topic_list(self, board):
        """Return list of Topic instances in board"""
        assert isinstance(board, Board)
        if board.is_empty():
            return self.latest_topic_list(board)
        else:
            return [t for t in board.topics()]

    def latest_topic_list(self, board):
        """Return the latest list of Topic instances in board

        This method first tries to download the topic list from 2ch, and 
        then returns the list.
        """
        assert isinstance(board, Board)
        try:
            self._echo(u("ダウンロード開始: %s") % board.title())
            board.update()
        except:
            self._echo(u("ダウンロード失敗: %s") % board.title())
            if board.is_empty():
                return []
        else:
            self._echo(u("ダウンロード完了: %s") % board.title())
        return [t for t in board.topics()]

    def messages(self, topic, renderer):
        """Return list of message instances belonging to topic"""
        assert isinstance(topic, Topic)
        if topic.is_empty():
            return self.latest_messages(topic, renderer)
        else:
            return renderer.render(topic)

    def latest_messages(self, topic, renderer):
        """Return the latest list of Message instances belonging to 
        topic

        This method first tries to download the messages from 2ch, and 
        then returns the list.
        """
        assert isinstance(topic, Topic)
        try:
            self._echo(u("ダウンロード開始: %s") % topic.title())
            topic.update()
        except:
            self._echo(u("ダウンロード失敗: %s") % topic.title())
            if topic.is_empty():
                return renderer.render(topic)
        else:
            self._echo(u("ダウンロード完了: %s") % topic.title())
        return renderer.render(topic)

    def _echo(self, text):
        """Send text to the user interface to show"""
        self._ui.echo(text)


