# -*- coding: utf-8 -*-

import unittest
import sys
import xml.dom.minidom as minidom
sys.path.append((sys.path[0] or ".") + "/../")

from config import *
from bbs import *


class BBSTestCase(unittest.TestCase):
    def test_build_categories(self):
        """BBS._build_categories()"""
        filepath = ".tmp"
        xml = """
          <bbs title="2ch">
            <category title="c1">
              <board title="t11" host="h11" path="p11" />
              <board title="t12" host="h12" path="p12" />
            </category>
            <category title="c2">
              <board title="t2" host="h2" path="p2" />
            </category>
          </bbs>"""
        bbs = BBS()
        bbs._filepath = filepath
        file(bbs._filepath,"w").write(xml)
        c1 = Category("c1")
        c1.append(Board("h11","p11","t11"))
        c1.append(Board("h12","p12","t12"))
        c2 = Category("c2")
        c2.append(Board("h2","p2","t2"))
        bbs = BBS()
        bbs._filepath = filepath
        categories = [c for c in bbs._build_categories()]
        for result_c, desired_c in zip(categories, [c1,c2]):
            for b1, b2 in zip([b1 for b1 in result_c.boards()],
                              [b2 for b2 in desired_c.boards()]):
                self.assert_((b1.host(),b1.path())==(b2.host(),b2.path()))
                
if __name__ == "__main__":
    unittest.main()
