/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITAPREF_H_
#define _KITAPREF_H_

#include <kdialogbase.h>
#include <qframe.h>

#include "kitafontprefbase.h"
#include "kitacolorprefbase.h"
#include "asciiartprefbase.h"

class KitaFontPrefPage;
class KitaColorPrefPage;

namespace Kita
{
    class AsciiArtPrefPage;
};

class KitaPreferences : public KDialogBase
{
    Q_OBJECT

public:
    KitaPreferences();

private:
    KitaFontPrefPage* m_fontPage;
    KitaColorPrefPage* m_colorPage;
    Kita::AsciiArtPrefPage* m_asciiArtPage;

signals:
    void fontChanged( const QFont& );
    void threadFontChanged( const QFont& );
};

class KitaFontPrefPage : public KitaFontPrefBase
{
    Q_OBJECT

public:
    KitaFontPrefPage( QWidget* parent = 0 );

public slots:
    void slotFontButtonClicked();
    void slotThreadFontButtonClicked();

private:
    void updateButtons();

signals:
    void fontChanged( const QFont& );
    void threadFontChanged( const QFont& );
};

class KitaColorPrefPage : public KitaColorPrefBase
{
    Q_OBJECT

public:
    KitaColorPrefPage( QWidget* parent = 0 );

public slots:
    void slotChangeButtonClicked();
};

namespace Kita
{
    class AsciiArtPrefPage : public AsciiArtPrefBase
    {
        Q_OBJECT
    public:
        AsciiArtPrefPage( QWidget* parent = 0 );
    public slots:
        void commit();
    };
};

#endif // _KITAPREF_H_
