/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITACONFIG_H
#define KITACONFIG_H

#include <qfont.h>

#include <kcompletion.h>

/**
@author Hideki Ikemoto
*/
class KitaConfig
{
    static KitaConfig* instance;
    QColor m_threadColor;
    QColor m_threadBackgroundColor;
    QColor m_popupColor;
    QColor m_popupBackgroundColor;
    QFont m_font;
    QFont m_threadFont;
    QString m_boardListURL;
    KCompletion m_nameCompletion;
    QStringList m_asciiArtList;
    bool m_showMailAddress;
    KitaConfig();
    virtual ~KitaConfig();
public:
    static KitaConfig* getInstance();
    static QFont& font() { return getInstance() ->m_font; }
    static void setFont( QFont font ) { getInstance() ->m_font = font; }
    static QFont& threadFont() { return getInstance() ->m_threadFont; }
    static void setThreadFont( QFont font ) { getInstance() ->m_threadFont = font; }
    static void setBoardListURL( QString url ) { getInstance() ->m_boardListURL = url; }
    static QString& boardListURL() { return getInstance() ->m_boardListURL; }
    static KCompletion* nameCompletion() { return & ( getInstance() ->m_nameCompletion ); }
    static void addNameCompletionItem( QString& item ) { getInstance() ->m_nameCompletion.addItem( item ); }
    static void setNameCompletionItems( QStringList list ) { getInstance() ->m_nameCompletion.setItems( list ); }
    static QColor& threadColor() { return getInstance() ->m_threadColor; }
    static void setThreadColor( QColor color ) { getInstance() ->m_threadColor = color; }
    static QColor& threadBackgroundColor() { return getInstance() ->m_threadBackgroundColor; }
    static void setThreadBackgroundColor( QColor color ) { getInstance() ->m_threadBackgroundColor = color; }
    static QColor& popupColor() { return getInstance() ->m_popupColor; }
    static void setPopupColor( QColor color ) { getInstance() ->m_popupColor = color; }
    static QColor& popupBackgroundColor() { return getInstance() ->m_popupBackgroundColor; }
    static void setPopupBackgroundColor( QColor color ) { getInstance() ->m_popupBackgroundColor = color; }
    static QStringList& asciiArtList() { return getInstance() ->m_asciiArtList; }
    static void setAsciiArtList( QStringList list ) { getInstance() ->m_asciiArtList = list; }
    static bool showMailAddress() { return getInstance() ->m_showMailAddress; }
    static void setShowMailAddresss( bool flag ) { getInstance() ->m_showMailAddress = flag; }
};

#endif
