/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITATHREADTABWIDGET_H
#define KITATHREADTABWIDGET_H

#include <qtabwidget.h>
#include <qtabbar.h>
#include <kparts/browserextension.h>

class KitaThreadPart;
class KitaThreadView;
class KURL;

namespace Kita
{
    class Thread;
};

/**
@author Hideki Ikemoto
*/
class KitaThreadTabWidget : public QTabWidget
{
    Q_OBJECT

public:
    KitaThreadTabWidget( QWidget* parent = 0, const char* name = 0, WFlags f = 0 );
    ~KitaThreadTabWidget();
    void focusSearchCombo();
    void reloadThread();
    void closeCurrentTab();

public slots:
    void showThread( const Kita::Thread* thread );
    void showThread( const QString& datURL, bool withNewTab = false );
    void showThreadWithNewTab( const Kita::Thread* thread ); // ad-hoc
    void deleteView( KitaThreadView* );

private:
    void connectSignals( KitaThreadView* );
    KitaThreadView* createView();

private slots:
    void slotOpenURLRequest( const KURL& url, const KParts::URLArgs& args = KParts::URLArgs() );

signals:
    void openURLRequest( const KURL& url, const KParts::URLArgs &args = KParts::URLArgs() );
    void signalChangeStatusbar( const QString& );
    void thread( const Kita::Thread* );
    void writeSucceeded();
    void bookmarked( const Kita::Thread*, bool on );
    void showThreadCompleted( const KURL& threadUrl );
};

class KitaThreadTabBar : public QTabBar
{
    Q_OBJECT

public:
    KitaThreadTabBar( QWidget* parent = 0, const char* name = 0 );
    ~KitaThreadTabBar();

protected:
    virtual void contextMenuEvent( QContextMenuEvent* e );

signals:
    void deleteMenuSelected( KitaThreadView* );
};

#endif
