/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KITACONFIG_H
#define KITACONFIG_H

#include <qfont.h>

/**
@author Hideki Ikemoto
*/
class KitaConfig{
  static KitaConfig* instance;
  QFont m_font;
  QFont m_threadFont;
  QString m_boardListURL;
  KitaConfig();
  virtual ~KitaConfig();
public:
  static KitaConfig* getInstance();
  static QFont& font() { return getInstance()->m_font;}
  static void setFont(QFont font) { getInstance()->m_font = font; }
  static QFont& threadFont() { return getInstance()->m_threadFont; }
  static void setThreadFont( QFont font ) { getInstance()->m_threadFont = font; }
  static void setBoardListURL( QString url ) { getInstance()->m_boardListURL = url; }
  static QString& boardListURL() { return getInstance()->m_boardListURL; }
};

#endif
