/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "urlconverttest.h"

void URLConvertTest::setUp()
{
  m_datURL = "http://pc.2ch.net/linux/dat/1022744633.dat";
  m_threadURL = "http://pc.2ch.net/test/read.cgi/linux/1022744633/";
  m_threadURL2 = "http://pc.2ch.net/test/read.cgi/linux/1022744633";
  m_subjectURL = "http://pc.2ch.net/linux/subject.txt";
  m_boardURL = "http://pc.2ch.net/linux/";
  m_boardURL2 = "http://pc.2ch.net/linux";

  // relative path.
  m_cachePath = QString( "pc.2ch.net/linux/1022744633.dat" );
}

void URLConvertTest::tearDown()
{
}

void URLConvertTest::testDatToThread()
{
  CPPUNIT_ASSERT_EQUAL( m_threadURL, Kita::datToThread( m_datURL ) );
}

void URLConvertTest::testThreadToDat()
{
  CPPUNIT_ASSERT_EQUAL( m_datURL, Kita::threadToDat( m_threadURL ) );
  CPPUNIT_ASSERT_EQUAL( m_datURL, Kita::threadToDat( m_threadURL2 ) );
}

void URLConvertTest::testBoardToSubject()
{
  CPPUNIT_ASSERT_EQUAL( m_subjectURL, Kita::boardToSubject( m_boardURL ) );
  CPPUNIT_ASSERT_EQUAL( m_subjectURL, Kita::boardToSubject( m_boardURL ) );
}

void URLConvertTest::testSubjectToBoard()
{
  CPPUNIT_ASSERT_EQUAL( m_boardURL, Kita::subjectToBoard( m_subjectURL ) );
}

void URLConvertTest::testDatToCache()
{
  CPPUNIT_ASSERT_EQUAL( m_cachePath, Kita::datToCache( m_datURL ) );
}

void URLConvertTest::testDatToBoard()
{
  CPPUNIT_ASSERT_EQUAL( m_boardURL, Kita::datToBoard( m_datURL ) );
}
