/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "kita_misc.h"

#include <kurl.h>
#include <qregexp.h>

namespace Kita {

QString datToBoard( const QString& datURL )
{
    KURL url( datURL );
    return KURL( url, "../" ).url();
}

QString datToThread( const QString& datURL )
{
  QRegExp regexp( "http://([^/]*)/([^/]*)/dat/(.*)\\.dat" );
  if( regexp.search( datURL ) == -1 ) {
    // no match
    return "";
  }
  QString url= QString( "http://%1/test/read.cgi/%2/%3/" )
                        .arg( regexp.cap(1) )
                        .arg( regexp.cap(2) )
                        .arg( regexp.cap(3) );
  return url;
}

QString threadToDat( const QString& threadURL )
{
  QRegExp regexp( "http://([^/]*)/test/read\\.cgi/([^/]*)/([^/]*)/?" );
  if( regexp.search( threadURL ) == -1 ) {
    // no match
    return "";
  }
  QString url = QString( "http://%1/%2/dat/%3.dat" )
                         .arg( regexp.cap(1) )
                         .arg( regexp.cap(2) )
                         .arg( regexp.cap(3) );
  return url;
}

QString boardToSubject( const QString& boardURL )
{
  KURL url( boardURL );
  url.addPath( "subject.txt" );
  return url.url();
}

QString subjectToBoard( const QString& subjectURL )
{
  return KURL( subjectURL, "." ).url();
}

QString datToCache( const QString& datURL )
{
  QRegExp regexp( "http://([^/]*)/([^/]*)/dat/(.*)" );
  if( regexp.search( datURL ) == -1 ) {
    return "";
  }
  return QString( "%1/%2/%3" ).arg( regexp.cap(1) )
                              .arg( regexp.cap(2) )
                              .arg( regexp.cap(3) );
}

};
