/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "pref.h"

#include <klocale.h>
#include <kfontdialog.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>

#include "kitafontprefbase.h"
#include "kitaconfig.h"

KitaPreferences::KitaPreferences()
    : KDialogBase(TreeList, i18n("Kita Preferences"),
                  Help|Default|Ok|Apply|Cancel, Ok)
{
    // this is the base class for your preferences dialog.  it is now
    // a Treelist dialog.. but there are a number of other
    // possibilities (including Tab, Swallow, and just Plain)
    QFrame *frame;
    frame = addPage(i18n("Font"), i18n("Font"));
    m_fontPage = new KitaFontPrefPage(frame);

//    frame = addPage(i18n("Second Page"), i18n("Page Two Options"));
//    m_pageTwo = new KitaPrefPageTwo(frame);

    connect( m_fontPage, SIGNAL( fontChanged( const QFont& ) ),
                         SIGNAL( fontChanged( const QFont& ) ) );

    connect( m_fontPage, SIGNAL( threadFontChanged( const QFont& ) ),
                         SIGNAL( threadFontChanged( const QFont& ) ) );
}

KitaFontPrefPage::KitaFontPrefPage( QWidget *parent )
    : KitaFontPrefBase(parent)
{
  fontButton->setText(KitaConfig::font().family());
  fontButton->setFont(KitaConfig::font());
  connect(fontButton, SIGNAL(clicked()), SLOT(slotFontButtonClicked()));

  threadFontButton->setText( KitaConfig::threadFont().family() );
  threadFontButton->setFont( KitaConfig::threadFont() );
  connect( threadFontButton, SIGNAL( clicked() ),
                             SLOT( slotThreadFontButtonClicked() ) );
}

void KitaFontPrefPage::slotFontButtonClicked()
{
  QFont font = fontButton->font();

  if( KFontDialog::getFont(font, false, this) == QDialog::Accepted ) {
    fontButton->setText(font.family());
    fontButton->setFont(font);
    emit fontChanged(font);
  }
}

void KitaFontPrefPage::slotThreadFontButtonClicked()
{
  QFont font = threadFontButton->font();

  if( KFontDialog::getFont( font, false, this ) == QDialog::Accepted ) {
    threadFontButton->setText( font.family() );
    threadFontButton->setFont( font );
    emit threadFontChanged( font );
  }
}

KitaPrefPageTwo::KitaPrefPageTwo( QWidget *parent )
    : QFrame(parent)
{
    QHBoxLayout *layout = new QHBoxLayout(this);
    layout->setAutoAdd(true);

    new QLabel(i18n("Add something here"), this);
}
#include "pref.moc"
