/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kitawritedialog.h"
#include "libkita/qcp932codec.h"
#include "libkita/thread.h"
#include "kitaconfig.h"
#include "kita2ch.h"

#include <ksqueezedtextlabel.h>
#include <klocale.h>
#include <kdebug.h>
#include <kstandarddirs.h>

#include <qlineedit.h>
#include <qtextedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qeucjpcodec.h>
#include <qfile.h>

#include <kio/job.h>

const char* kaomoji[] = {
  "",
  "(ߢώ)!!!!!",
  "ʎߧՎߡˎώ",
  "(++)ώގ",
  "((((((ߧ))))))ގގ̎ގَ̎ގ",
  "(ء`)Ύގ",
  "( _`)̎",
  "(`)Ύ܎",
  "ʎώˎ!!",
  "(;`)ʎʎ",
//  "(?)׎",
  "(ߧ)ʎ?",
  "ߎ(ɧ`)ߎ",
  "(ߧՎ)Ύߎ",
  "ʡϡˎ!!",
  "(-`).()",
  "(ҡϡ)Ҏގ",
  NULL
};

KitaWriteDialogPrivate * KitaWriteDialog::s_private = 0;

KitaWriteDialog::KitaWriteDialog(QWidget *parent, const char *name)
  : KitaWriteDialogBase(parent, name)
{
  QFont font = KitaConfig::font();
  bodyText->setFont( font );
  nameLine->setFont( font );
  nameLabel->setFont( font );
  mailLine->setFont( font );
  mailLabel->setFont( font );

  faceCombo->clear();
  int i=0;
  while( kaomoji[i] ) {
    QEucJpCodec codec;
    QString str = codec.toUnicode( kaomoji[i], strlen( kaomoji[i] ) );
    faceCombo->insertItem( str );
    i++;
  }
}

KitaWriteDialog::~KitaWriteDialog()
{
}

const QString KitaWriteDialog::name() const
{
  return nameLine->text();
}

const QString KitaWriteDialog::mail() const
{
  return mailLine->text();
}

const QString KitaWriteDialog::body() const
{
  return bodyText->text();
}

void KitaWriteDialog::fetchPostInfo( Kita::PostInfo * storage ) const
{
  storage->name = name();
  storage->mail = mail();
  storage->body = body();
}

// TODO: Thread饹Ȥ褦˽񤭴
KitaWriteDialog* KitaWriteDialog::open( const Kita::PostInfo& info,
                                        const Kita::Thread& thread )
{
  if ( ! info.check() ) return 0;
  if ( ! s_private ) {
    s_private = new KitaWriteDialogPrivate;
    if ( ! s_private ) return 0;
  }

  KitaWriteDialog * new_dlg = new KitaWriteDialog;
  if ( ! new_dlg ) return 0;

  new_dlg->m_postInfo = info;
  s_private->m_heaplist.append( new_dlg );

  new_dlg->connect( new_dlg->buttonOk, SIGNAL( clicked() ), new_dlg, SLOT( postMessage() ) );

  // set fields
  new_dlg->nameLine->setText(info.name);
  new_dlg->mailLine->setText(info.mail);
  new_dlg->bodyText->setText(info.body);

  new_dlg->boardNameLabel->setText( thread.boardName() );
  new_dlg->threadNameLabel->setText( thread.name() );
  new_dlg->threadURLLabel->setText( thread.url().url() );

  new_dlg->setCaption( i18n("Write in %1").arg( thread.name() ) );
  return new_dlg;
}

static void logPostMessage( const Kita::PostInfo& postInfo,
                            const QString& boardName,
                            const QString& threadName,
                            const QString& threadURL )
{
  QDateTime now = QDateTime::currentDateTime();
  QString logPath = locateLocal( "appdata", "log.txt" );

  QFile file( logPath );
  if ( file.open( IO_WriteOnly | IO_Append ) ) {
    QTextStream stream( &file );
    stream.setEncoding( QTextStream::UnicodeUTF8 );

    stream << "Date   : " << now.toString( "yyyy/MM/dd hh:mm:ss" ) << endl; // ߻
    stream << "Board  : " << boardName << endl;
    stream << "Thread : " << threadName << endl;
    stream << "URL    : " << threadURL << endl;
    stream << "Name   : " << postInfo.name << endl;
    stream << "Mail   : " << postInfo.mail << endl << endl;
    stream << postInfo.body << endl;
    stream << "----------------------------------------" << endl;

    file.close();
  }
}

void KitaWriteDialog::postMessage()
{
  fetchPostInfo( &m_postInfo );
  if ( ! m_postInfo.check() )
	return ;

  KURL bbscgi;
  bbscgi.setProtocol( "http" );
  bbscgi.setHost( m_postInfo.host );
  bbscgi.setPath( m_postInfo.bbscgi );

  //int mib = QTextCodec::codecForName("CP932")->mibEnum();
  QString postStr = m_postInfo.postStr();

  kdDebug() << "query: " << postStr << endl;
  m_array.resize(0);

  KIO::TransferJob * job = KIO::http_post(bbscgi, postStr.utf8(), true);
  job->addMetaData("content-type", "Content-type: application/x-www-form-urlencoded");
  job->addMetaData("referrer", QString("http://%1/%2/").arg(m_postInfo.host).arg(m_postInfo.bbs) );

  if ( ! m_postInfo.cookie.isEmpty() )
	  job->addMetaData("cookie", m_postInfo.cookie.prepend("Cookie: "));

  // TODO: rewrite!
  logPostMessage( m_postInfo, boardNameLabel->text(), threadNameLabel->text(), threadURLLabel->text() );

  emit postStarted( job, m_postInfo );

  connect( job, SIGNAL( data(KIO::Job*, const QByteArray&) ),
	   this, SLOT( slotRecieveData(KIO::Job *, const QByteArray &) ) );
  connect( job, SIGNAL( result(KIO::Job *) ),
	   this, SLOT( slotPostFinished(KIO::Job *) ) );
}

void KitaWriteDialog::slotRecieveData(KIO::Job *, const QByteArray &data)
{
  m_array.append( data.data() );
}

void  KitaWriteDialog::slotPostFinished(KIO::Job *job)
{
  QString response = QTextCodec::codecForName("sjis")->toUnicode( m_array );
  QCString output = QTextCodec::codecForName("eucJP")->fromUnicode( response );
  kdDebug() << "response: '" << output.data() << "'" << endl;
  emit postFinished( job );
  KURL bbscgi;
  bbscgi.setProtocol( "http" );
  bbscgi.setHost( m_postInfo.host );
  bbscgi.setPath( m_postInfo.bbscgi );
  emit postResponse( response, bbscgi );

  m_array.resize(0);

  int idx = s_private->m_heaplist.find( this );
  if ( idx != -1 ) 
    delete this;
}

// vim:sw=2:
