/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef FAVORITETHREADS_H
#define FAVORITETHREADS_H

#include <kurl.h>

#include <qmap.h>
#include <qxml.h>
#include <qptrlist.h>
#include <qdict.h>

#include "thread.h"

/**
@author Hideki Ikemoto
*/
class FavoriteThreads{
  static FavoriteThreads* instance;
  QDict<Kita::Thread> m_threadDict;
  FavoriteThreads();
  ~FavoriteThreads();
public:
//  typedef QDict<Kita::Thread>::const_iterator const_iterator;
  static FavoriteThreads* getInstance();
  void insert( const Kita::Thread* thread );
  void remove( const QString& datURL );
  bool contains( const QString& datURL ) const;
  const QDict<Kita::Thread>& threads() const { return m_threadDict; };
  static FavoriteThreads* fromXml( const QString& xml );
  const QString toXml() const;

  static bool test();
};

class FavoritesXmlParser : public QXmlDefaultHandler
{
  bool m_inFavorites;
  bool m_inThread;
  bool m_isValid;
  QString m_characters;
  QPtrList<Kita::Thread> m_threadList;
  Kita::ThreadXmlParser* m_threadParser;
public:
  FavoritesXmlParser() : m_inFavorites(false), m_inThread(false), m_isValid(false) {};
  ~FavoritesXmlParser() {};
  bool startElement( const QString& namespaceURI, const QString& localName, const QString& qName, const QXmlAttributes& atts );
  bool endElement( const QString& namespaceURI, const QString& localName, const QString& qName );
  bool characters( const QString& ch );
  bool isValid() const { return m_isValid; }
  QPtrList<Kita::Thread> getThreads() const { return m_threadList; }
};

#endif
