
#ifndef K2CHTREE_MODULE_H
#define K2CHTREE_MODULE_H

#include <konq_sidebartreemodule.h>
class KonqSidebarTreeModule;

#include <qmap.h>
template<class type> class QDict;

#include <kaction.h>
class KAction;
class KActionCollection;

//#include "k2ch_settings.h"
#include "k2ch.h"
#include "k2chtree_item.h"
#include "bookmark_item.h"

class KonqSidebarK2chTreeModule : public QObject, public KonqSidebarTreeModule
{
    Q_OBJECT
public:
    KonqSidebarK2chTreeModule( KonqSidebarTree * parentTree, const char * name = 0L );
    virtual ~KonqSidebarK2chTreeModule();

    virtual void addTopLevelItem( KonqSidebarTreeTopLevelItem * item );
    
    //virtual void openTopLevelItem( KonqSidebarTreeTopLevelItem * item );

    virtual void followURL( const KURL & url );

    KXMLGUIClient * xmlGUIClient() const { return m_xmlguiclient; }
public slots:
    //virtual void rightButtonPressed( QListViewItem *, const QPoint &, int );

    //Memo:
    //KonqSidebarTree : KListView : QListView * KonqSidebarTreeModule::tree();
    // retrieve a Ptr of the QListView Widget.

private slots:
    void slotSettingsChanged() {};
    void openWithK2ch();
    void executeItem( QListViewItem * item );

protected:
    KonqSidebarTreeTopLevelItem * m_topLevelItem;
    K2ch::Base * m_base; //will be removed after release.: Get 'm_base' info. by *.desktop files and the 'm_base' stored as a child of the 'm_topLevelItem'.
    QDict<KonqSidebarTreeItem> m_treeItemDict; // a QDict of QListViewItem-s : Key of the Dict is 'treeItem->externalURL().url()'.
    
    KActionCollection * m_collection;
    KXMLGUIClient * m_xmlguiclient;
    //static K2chSettings s_settings;

    void fillBookmarkGroup( KonqSidebarTreeItem * parentItem, KBookmarkGroup group );
    void addBookmarkItem();
    void addBaseItem( KonqSidebarK2chBaseItem * base_item );
    
};

#endif
// vim:sw=4
