/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KITACATEGORY_H
#define KITACATEGORY_H

#include <qvaluelist.h>

#include "board.h"

/**
@author Hideki Ikemoto
*/

namespace Kita {
  class Board;

  class Category{
    QString m_name;
    QValueList<Board> m_boardList;
  public:
    Category( const QString& name );
    ~Category();
    void append( const Board& board );
    const QValueList<Board>& getBoardList() const;
    const QString& name() const;
  };
};

#endif
