
#include "k2chtree_module.h"
#include "k2chtree_item.h"

#include <konqbookmarkmanager.h>

#include <qptrlist.h>
#include <qtextcodec.h>
#include <qsjiscodec.h>
#include <qcursor.h>
#include <qpopupmenu.h>
#include <qdir.h>

#include <typeinfo>

extern "C" {

    KonqSidebarTreeModule* create_konq_sidebartree_k2chtree( KonqSidebarTree* pa )
    { //will be called when this modules is loaded.
	return new KonqSidebarK2chTreeModule( pa );
    }
}

class QListView;
class KListView;
class QListViewItem;
class KListViewItem;

#if 0
static KStaticDeleter<K2chSettings> sd;
K2chSettings * KonqSidebarK2chModule::s_settings = 0L;
#endif

KonqSidebarK2chTreeModule::KonqSidebarK2chTreeModule( KonqSidebarTree * parentTree, const char * name )
  : QObject( 0, name ), KonqSidebarTreeModule( parentTree )
  , m_topLevelItem( 0 )
  , m_base( 0 )
{
#if 0
    //Settings
    if ( ! s_settings ) {
	s_settings = sd.setObject(
		new K2chSettings( 0 )
	);
	s_settings->readSettings( true );
    }

    connect( s_settings, SIGNAL( settingsChanged() ), SLOT( slotSettingsChanged() ) );
#endif

    //ActionCollection
    m_xmlguiclient = new KXMLGUIClient();
    //m_collection = new KActionCollection( this, "k2ch_sidebar actions" );
    m_collection = m_xmlguiclient->actionCollection();
    KStdAction::open( this, SLOT( open() ), m_collection );
    new KAction( i18n("Open with K2ch"), KShortcut(), this, SLOT( openWithK2ch() ) );
    //new KAction( i18n(""), "", 0, this, SLOT( slot() ), m_collection, "" );

    //KParts::BrowserExtension::childObject( tree()->part() ); // not work
    tree()->setSorting( -1 );

    connect( tree(), SIGNAL( clicked(QListViewItem *) ),
	     this, SLOT( executeItem(QListViewItem *) ) );
}

KonqSidebarK2chTreeModule::~KonqSidebarK2chTreeModule(){

    //delete m_collection;

    //All ListViewItem of child tree will be deleted,
    //when m_topLevelItem (parent as QObject) is deleted.
    //So we do nothig.

    if ( m_base ) delete m_base;
}

void KonqSidebarK2chTreeModule::addTopLevelItem( KonqSidebarTreeTopLevelItem * item )
{
    m_topLevelItem = item;


    addBookmarkItem();
    
    QStringList item_dirList = KGlobal::dirs()->findDirs("data","konq_k2chtree");
    if ( ! m_base ) { 
	m_base = new K2ch::Base;
	QTextCodec *codec = QTextCodec::codecForName( "eucJP" );
	m_base->name = codec->toUnicode( "2ͤؤ褦" );
	m_base->topURL = "http://www.2ch.net/";
	m_base->bbsmenu = "http://www.ff.iij4u.or.jp/~ch2/bbsmenu.html";
	//m_base->topURL = 'url of desktopfile'
    }

    KonqSidebarK2chBaseItem * base_item;

    base_item = new KonqSidebarK2chBaseItem( m_topLevelItem, m_topLevelItem, *m_base );
    base_item->setMethod( K2ch::HTTP );
    m_treeItemDict.insert( (static_cast<KonqSidebarK2chTreeItem*>( base_item ))->externalURL().url(-1), base_item );
    base_item->setText( 0, base_item->text( 0 ).prepend("[HTTP]") );

    base_item = new KonqSidebarK2chBaseItem( m_topLevelItem, m_topLevelItem, *m_base );
    base_item->setMethod( K2ch::K2CH );
    m_treeItemDict.insert( (static_cast<KonqSidebarK2chTreeItem*>( base_item ))->externalURL().url(-1), base_item );
    base_item->setText( 0, base_item->text( 0 ).prepend("[K2ch]") );

}

void KonqSidebarK2chTreeModule::addBookmarkItem()
{
    bool found = false;
    KBookmarkManager * mgr = KonqBookmarkManager::self();
    KBookmarkGroup root = mgr->root();
    for ( KBookmark bk = root.first(); ! bk.isNull(); bk = root.next(bk) )
    {
	if ( bk.isGroup() && bk.text() == "K2ch" ) {
	    found = true;
	    KonqSidebarBookmarkItem * item = new KonqSidebarBookmarkItem( m_topLevelItem, m_topLevelItem, bk, 0 );
	    item->setText( 0, i18n("Bookmarks for K2ch") );
	    fillBookmarkGroup( item, bk.toGroup() );
	}

    }
    if ( ! found ) {
	root.createNewFolder( mgr, "K2ch" );
	mgr->emitChanged( root );
	addBookmarkItem();
    }
}

void KonqSidebarK2chTreeModule::fillBookmarkGroup( KonqSidebarTreeItem * parentItem, KBookmarkGroup group )
{
    int n = 0;
    for ( KBookmark bk = group.first() ; !bk.isNull() ; bk = group.next(bk), ++n )
    {
	if ( !bk.isSeparator() )
	{
	    KonqSidebarTreeItem * tree_item = m_treeItemDict[bk.url().url(-1)];
	    
	    printf( "%p %s\n", static_cast<void*>(tree_item), bk.url().url().latin1() );
	    if ( tree_item ) {
		if ( typeid( tree_item ) == typeid( KonqSidebarK2chBoardItem *) )
		{
		} else
		if ( typeid( tree_item ) == typeid( KonqSidebarK2chThreadItem *) )
		{
		}
	    }
				
	    KonqSidebarBookmarkItem * bk_item = new KonqSidebarBookmarkItem( parentItem, m_topLevelItem, bk, n );
	    if ( bk.isGroup() )
	    {
		KBookmarkGroup grp = bk.toGroup();
		fillBookmarkGroup( bk_item, grp );
		if ( bk_item->childCount() == 0 )
		{
		    bk_item->setExpandable( false );
		}
	    } else {
		bk_item->setExpandable( false );
	    }
	}
    }
}

void KonqSidebarK2chTreeModule::followURL( const KURL & url ){
    KonqSidebarTreeItem * item = m_treeItemDict[ url.url(-1) ];
    printf( " KonqSidebarK2chTreeModule::followURL::\n" );
    printf( "    url: %s, item: %p\n", url.url(-1).latin1(), (void*)item );
    if ( item ) { 
	tree()->ensureItemVisible( item );
	item->setSelected( true );
    }
}

void KonqSidebarK2chTreeModule::openWithK2ch(){
    KonqSidebarK2chTreeItem * item = dynamic_cast<KonqSidebarK2chTreeItem*>(tree()->selectedItem());
    if ( item ) tree()->openURLRequest( item->externalURL( K2ch::K2CH ) );
}

void KonqSidebarK2chTreeModule::executeItem( QListViewItem * item )
{
    KonqSidebarK2chTreeItem * k2ch_item = dynamic_cast<KonqSidebarK2chTreeItem *>(item);
    if ( k2ch_item ) k2ch_item->itemSelected();
}
//#include "k2chtree_module.moc.cpp"
// vim:sw=4
