/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KITAPREF_H_
#define _KITAPREF_H_

#include <kdialogbase.h>
#include <qframe.h>

#include "kitafontprefbase.h"

class KitaFontPrefPage;
class KitaPrefPageTwo;

class KitaPreferences : public KDialogBase
{
    Q_OBJECT

public:
    KitaPreferences();

private:
    KitaFontPrefPage *m_fontPage;
    KitaPrefPageTwo *m_pageTwo;

signals:
  void fontChanged( const QFont& );
};

class KitaFontPrefPage : public KitaFontPrefBase
{
    Q_OBJECT

public:
    KitaFontPrefPage( QWidget *parent = 0 );

public slots:
  void slotFontButtonClicked();

signals:
  void fontChanged( const QFont& );
};

class KitaPrefPageTwo : public QFrame
{
    Q_OBJECT

public:
    KitaPrefPageTwo( QWidget *parent = 0 );
};

#endif // _KITAPREF_H_
