/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kitathreadtabwidget.h"

#include "kitathreadpart.h"
#include "kitathreadview.h"

#include <klibloader.h>
#include <kpopupmenu.h>
#include <krun.h>

#include <qclipboard.h>
#include <qapplication.h>

#define MAX_TABLABEL_LEN 20

KitaThreadTabWidget::KitaThreadTabWidget(QWidget *parent, const char *name, WFlags f)
 : QTabWidget(parent, name, f)
{
  setTabBar( new KitaThreadTabBar( this ) );
  connect( tabBar(), SIGNAL( deleteMenuSelected( KitaThreadView* ) ),
                     SLOT( deleteView( KitaThreadView* ) ) );

  KLibFactory* factory = KLibLoader::self()->factory( "libkitapart" );
  if( ! factory ) {
    return;
  }
  KitaThreadPart* part = static_cast<KitaThreadPart *>( factory->create( this, "thread", "KitaThreadPart" ) );
  KitaThreadView* view = static_cast<KitaThreadView *>( part->widget() );
  addTab( view, "thread" );
  connectSignals( view );
}

KitaThreadTabWidget::~KitaThreadTabWidget()
{
}

void KitaThreadTabWidget::showThread( const Kita::Thread& thread )
{
  // TODO: 줬ɤΥ֤ˤǤˤȤϤȤ
  static_cast<KitaThreadView *>( currentPage() )->showThread( thread );
  setTabLabel( currentPage(), thread.name().left( MAX_TABLABEL_LEN ) );
  setTabToolTip( currentPage(), thread.name() );
}

void KitaThreadTabWidget::showThreadWithNewTab( const Kita::Thread& thread )
{
  KLibFactory* factory = KLibLoader::self()->factory( "libkitapart" );
  if( ! factory ) {
    return;
  }
  KitaThreadPart* part = static_cast<KitaThreadPart *>( factory->create( this, "thread", "KitaThreadPart" ) );
  KitaThreadView* view = static_cast<KitaThreadView *>( part->widget() );
  addTab( view, thread.name().left( MAX_TABLABEL_LEN ) );
  setTabToolTip( view, thread.name() );

  connectSignals( view );
  view->showThread( thread );
  showPage( view );
}

void KitaThreadTabWidget::connectSignals( KitaThreadView* view )
{
  connect( view, SIGNAL( openURLRequest( const KURL&, const KParts::URLArgs& ) ),
           this, SIGNAL( openURLRequest( const KURL&, const KParts::URLArgs& ) ) );
  connect( view, SIGNAL( signalChangeStatusbar( const QString& ) ),
           this, SIGNAL( signalChangeStatusbar( const QString& ) ) );
  connect( view, SIGNAL( thread( const Kita::Thread& ) ),
           this, SIGNAL( thread( const Kita::Thread& ) ) );
  connect( view, SIGNAL( writeSucceeded() ),
           this, SIGNAL( writeSucceeded() ) );
  connect( view, SIGNAL( bookmarked( const Kita::Thread&, bool ) ),
           this, SIGNAL( bookmarked( const Kita::Thread&, bool ) ) );
  connect( view, SIGNAL( showThreadCompleted( const KURL& ) ),
           this, SIGNAL( showThreadCompleted( const KURL& ) ) );
}

void KitaThreadTabWidget::deleteView( KitaThreadView* view )
{
  qDebug("deleteView(%p)", static_cast<void*>( view ) );
  removePage( view );
  delete view;

  if( count() == 0 ) {
    // TODO: 󥹥ȥ饯ǤƱåȤäƤ롣
    KLibFactory* factory = KLibLoader::self()->factory( "libkitapart" );
    if( ! factory ) {
      return;
    }
    KitaThreadPart* part = static_cast<KitaThreadPart *>( factory->create( this, "thread", "KitaThreadPart" ) );
    KitaThreadView* view = static_cast<KitaThreadView *>( part->widget() );
    addTab( view, "thread" );
    connectSignals( view );

    showPage( view );
  }
}

KitaThreadTabBar::KitaThreadTabBar( QWidget* parent, const char* name )
 : QTabBar( parent, name )
{
}

KitaThreadTabBar::~KitaThreadTabBar()
{
}

void KitaThreadTabBar::contextMenuEvent( QContextMenuEvent* e )
{
  KPopupMenu popup( 0 );
  popup.insertItem( i18n("Open with Web Browser"), 0 );
  popup.insertItem( i18n("Copy title and URL"), 1 );
  popup.insertItem( i18n("Close this tab"), 2 );

  QTabWidget* parent = static_cast<QTabWidget*>( parentWidget() );
  KitaThreadView* threadView = static_cast<KitaThreadView*>( parent->currentPage() );
  QClipboard* clipboard = QApplication::clipboard();

  switch( popup.exec( e->globalPos() ) ) {
  case 0:
    KRun::runURL( threadView->threadURL(), "text/html" );
    break;
  case 1:
    clipboard->setText( threadView->threadName() + "\n" + threadView->threadURL().url() );
    break;
  case 2:
    emit deleteMenuSelected( threadView );
    break;
  default:
    break;
  }

//  qDebug("currentPage = %s", static_cast<const char *>( tab( currentTab() )->text().local8Bit() ) );
}
