/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KITACACHEINFO_H_
#define _KITACACHEINFO_H_

#include <kurl.h>

#include <qmap.h>

/**
 * 
 * Hideki Ikemoto
 **/
class KitaCacheInfo
{
public:
  static KitaCacheInfo* getInstance();
  void setReadNum(const KURL& url, int num);
  int readNum(const KURL& url);
  void setResNum( const KURL& url, int num );
  int resNum( const KURL& url );
  friend QDataStream& operator<<(QDataStream& s, KitaCacheInfo& c);
  friend QDataStream& operator>>(QDataStream& s, KitaCacheInfo& c);
private:
  KitaCacheInfo();
  ~KitaCacheInfo();
  QMap<QString, int> m_readDict;
  QMap<QString, int> m_resNumDict;
  static KitaCacheInfo* instance;
};

#endif
