/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KITATHREADVIEW_H_
#define _KITATHREADVIEW_H_

#include <qwidget.h>
#include <qcstring.h>
#include <qtextbrowser.h>

#include <kurl.h>
#include <dom/dom_node.h>
#include <kparts/browserextension.h>

#include "kitathreadviewbase.h"
#include "kita2ch.h"
#include "libkita/thread.h"
#include "libkita/board.h"

class KURL;
class KitaHTMLPart;
class KitaWriteDialog;

#include <qvaluestack.h> // for gcc-2.9x
template<class T> class QValueStack;

namespace KIO {
  class Job;
};

#include <dom/html_base.h>

/**
 *
 * Hideki Ikemoto
 **/

class KitaThreadView : public KitaThreadViewBase
{
  Q_OBJECT

public:
  KitaThreadView( QWidget *parent, const char *name=0 );
  ~KitaThreadView();
  const QString threadSubject() const;
  void searchNext( const QStringList &input );
  void killJob();
  KParts::BrowserExtension* browserExtension();

public slots:
  void showThread( const Kita::Thread& thread );
  void setFont( const QFont& font );

protected slots:
  void slotDOMNodeActivated( const DOM::Node& node );
  void slotPopupMenu( KXMLGUIClient *, const QPoint&, const KURL&, const QString&, mode_t );
  void slotOpenURLRequest( const KURL&, const KParts::URLArgs& );

private: // Private attributes
  Kita::ThreadAccess* m_access;
  Kita::Thread m_thread;
  KitaHTMLPart* m_threadPart;
  int m_serverTime;
  QWidget * m_parent;
  Kita::PostInfo m_postInfo;
  QFrame* m_popup;
  QTextBrowser* m_browser;

  void insertSearchCombo();
  KURL filterReadCGI( const KURL& );
  int getServerTimeFromHttpHeaders( const QString& headers );
  void setSubjectLabel( const QString& boardName, const QString& threadName );
  KitaWriteDialog* openDialog( const Kita::PostInfo& info );
  const QString footer( int ) const;
  QStringList parseSearchQuery( const QString &input ) const;
  void update( const QString& result );
  void updateButton();

private slots:
  void slotSearchButton();
  void slotHighLightenButton( bool yes );
  void slotOnURL( const QString& url );
  void slotReloadButton();
  void slotPostStarted( KIO::Job*, const Kita::PostInfo& );
  void slotBookmarkButtonClicked( bool on );
  void slotWriteButtonClicked();
  void slotShowErrorDialog( const QString& input, const KURL& urlOfInput = 0 );
  void hidePopup();

signals:
  void showThreadCompleted( const KURL& threadUrl );
  void datURLRedirected( const KURL& newDatURL );
  void signalChangeStatusbar( const QString& );
  void postResponse( const QString& response, const KURL& bbscgi = KURL() );
  //re-impl signals of KParts::Browserextension of KHTMLPart
  void openURLRequest( const KURL &url, const KParts::URLArgs &args = KParts::URLArgs() );
  void createNewWindow( const KURL &url, const KParts::URLArgs &args = KParts::URLArgs() );
  void setLocationBarURL( const QString &url );
  void enableAction( const char * name, bool enabled );
  void popupMenu(KXMLGUIClient *, const QPoint&, const KURL&, const QString&, mode_t);
  void thread( const Kita::Thread& );
  void writeSucceeded();
  void bookmarked( const Kita::Thread&, bool on );
};

#endif
