/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kitacacheinfo.h"

#include <kurl.h>

#include <qmap.h>
#include <qdatastream.h>

KitaCacheInfo* KitaCacheInfo::instance = 0;

KitaCacheInfo::KitaCacheInfo() : m_vestedDict()
{
}

KitaCacheInfo::~KitaCacheInfo()
{
}

KitaCacheInfo* KitaCacheInfo::getInstance()
{
  if( instance == 0 ) {
    instance = new KitaCacheInfo();
  }
  return instance;
}

int KitaCacheInfo::getVestedNum(const KURL& url)
{
  QString key = url.prettyURL();
  if(m_vestedDict.contains(key)) {
    return m_vestedDict[key];
  } else {
    return 0;
  }
}

void KitaCacheInfo::setVestedNum(const KURL& url, int num)
{
  m_vestedDict.insert(url.prettyURL(), num);
}
  
QDataStream& operator<<(QDataStream& s, KitaCacheInfo& c)
{
  s << c.m_vestedDict;
  return s;
}

QDataStream& operator>>(QDataStream& s, KitaCacheInfo& c)
{
  s >> c.m_vestedDict;
  return s;
}
