/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef FAVORITELISTVIEW_H
#define FAVORITELISTVIEW_H

#include <klistview.h>

#include "libkita/board.h"
#include "libkita/thread.h"

/**
 *
 * @author Hideki Ikemoto <ikemo@users.sourceforge.jp>
 **/
class FavoriteListView : public KListView
{
  Q_OBJECT

public:
  /**
   * Constructor
   *
   * @param parent parent widget.
   * @param name widget name.
   */
  FavoriteListView( QWidget* parent = 0, const char *name = 0 );

  /**
   * Destructor
   */
  ~FavoriteListView();

  /**
   *
   */
  void update();

private slots:

  /**
   * @param item clicked item.
   */
  void loadThread( QListViewItem* item );

signals:

  /**
   * @param thread ɽ륹
   */
  void signalShowThread( const Kita::Thread& thread );
};

#endif
