/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "favoritelistview.h"

#include "libkita/favoritethreads.h"
#include "libkita/board.h"

#include <qmap.h>

#include <klocale.h>

enum FavoriteListViewRows {
  Row_Board,
  Row_Icon,
  Row_Subject,
  Row_ResNum,
  Row_Vested,
  Row_Unread,
  Row_DatName,
  Row_DatURL
};

FavoriteListView::FavoriteListView(QWidget* parent, const char *name)
 : KListView(parent, name)
{
  addColumn(i18n("Board"));
  addColumn("");
  addColumn(i18n("Title"));
  addColumn(i18n("ResNum"));
  addColumn(i18n("Vested"));
  addColumn(i18n("Unread"));
  addColumn(i18n("Dat"));

  setColumnWidth(Row_Subject, 400);
  setColumnWidthMode(Row_Subject, QListView::Manual);

  connect( this, SIGNAL( clicked(QListViewItem*) ),
                 SLOT( loadThread(QListViewItem*) ) );
}

FavoriteListView::~FavoriteListView()
{
}

void FavoriteListView::update()
{
  const QMap<QString, Kita::Thread>& threads = FavoriteThreads::getInstance()->threads();
  FavoriteThreads::const_iterator it;

  clear();

  for(it = threads.begin(); it != threads.end(); ++it) {
    const Kita::Thread& thread = it.data();
    const Kita::Board* board = thread.getBoard();

    new KListViewItem( this,
                       board->name(),
                       "",
                       thread.name(),
                       QString("%1").arg(thread.resNum(), 4),
                       "",
                       "",
                       thread.datURL().fileName(),
                       thread.datURL().prettyURL() );
  }
}

void FavoriteListView::loadThread( QListViewItem* item )
{
  if( ! item ) return;

  const QMap<QString, Kita::Thread>& threads = FavoriteThreads::getInstance()->threads();
  FavoriteThreads::const_iterator it;

  for(it = threads.begin(); it != threads.end(); ++it) {
    const Kita::Thread& thread = it.data();

    if( thread.datURL().prettyURL() == item->text( Row_DatURL ) ) {
      emit signalShowThread( thread );
    }
  }
}

