
#include <kcmodule.h>
#include <kgenericfactory.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <kconfig.h>

#include "k2ch_kcmwidget.h"
#include "k2ch_config.h"

using namespace K2chConfig;

class K2chKCM : public KCModule
{
public:
    K2chKCM( QWidget *parent, const char *name, const QStringList & );
    virtual ~K2chKCM();

    virtual void load();
    virtual void save();
    virtual void defaults();
    virtual QString quickHelp() const;

signals:
    void textChanged(const QString&);
private:
    QString _quickHelp;
    K2chKCMWidget * m_widget;
    KConfig * m_config;
private slots:
    void slotCacheDirSelectionChanged(const QString&);
};

#include <qmessagebox.h>
#include <qlineedit.h>
#include <qcombobox.h>

typedef  KGenericFactory <K2chKCM, QWidget> K2chKCMFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_k2ch, K2chKCMFactory("kcmk2ch") );

K2chKCM::K2chKCM( QWidget *parent, const char *name, const QStringList& )
  : KCModule( K2chKCMFactory::instance(), parent, name )
{
    m_widget = new K2chKCMWidget( this );

    QStringList config_dirs = KGlobal::dirs()->findDirs("config", 0 );
    //QMessageBox::information( 0, "", config_dirs.join( "\n" ) );
    QString personal_config = config_dirs.first().append("kio_k2chrc");
    m_config = new KConfig( personal_config );

    load();

    connect( m_widget, SIGNAL( changed(bool) ),
	     this, SIGNAL( changed(bool) ) );
}

K2chKCM::~K2chKCM()
{
    if( m_widget ) delete m_widget;
    if( m_config ) delete m_config;
}

void K2chKCM::load()
{
    m_widget->CacheDirEdit->setText( m_config->readPathEntry(s_cacheDirEntry, s_cacheDirDefault() ) );
    m_widget->DatMimeType->lineEdit()->setText( m_config->readEntry(s_datMimeEntry, s_datMimeDefault) );
    m_widget->SubjectMimeType->lineEdit()->setText( m_config->readEntry(s_subjectMimeEntry, s_subjectMimeDefault) );
}

void K2chKCM::save()
{
    QString cacheDir = m_widget->CacheDirEdit->text();
    if ( ! cacheDir.isEmpty() ) {
	// kio stack doesn't eat PathEntries.
	m_config->writeEntry( s_cacheDirEntry, cacheDir ); 
    } else {
	m_config->deleteEntry( s_cacheDirEntry );
    }
    QString datMimeType = m_widget->DatMimeType->currentText();
    if ( ! datMimeType.isEmpty() ) {
	m_config->writeEntry( s_datMimeEntry, datMimeType );
    } else {
	m_config->deleteEntry( s_datMimeEntry );
    }
    QString subjectMimeType = m_widget->SubjectMimeType->currentText();
    if ( ! subjectMimeType.isEmpty() ) {
	m_config->writeEntry( s_subjectMimeEntry, subjectMimeType );
    } else {
	m_config->deleteEntry( s_subjectMimeEntry );
    }

    m_config->sync();
}

void K2chKCM::defaults()
{
    m_widget->CacheDirEdit->setText( 0 );
    m_widget->DatMimeType->lineEdit()->setText( s_datMimeDefault );
    m_widget->SubjectMimeType->lineEdit()->setText( s_subjectMimeDefault );
    emit changed( false );
    //m_widget->defaults();
}

QString K2chKCM::quickHelp() const
{
    return _quickHelp;
}

void K2chKCM::slotCacheDirSelectionChanged(const QString &)
{
    emit changed( true );
}
// vim:sw=4:
