
#ifndef K2CH_H
#define K2CH_H

#include <qobject.h>

#include <qstring.h>
#include <qptrlist.h>
#include <qcstring.h>
#include <qdict.h>

#include <kurl.h>
#include <kio/jobclasses.h>
#include <kio/job.h>

class QProgressDialog;

namespace K2ch {

    enum Method {
	HTTP,
	K2CH
    };

    class Element : public QObject {
	Q_OBJECT
    public:
	Element() : QObject(), m_array(0), m_currentjob(0), m_progress(0) {}
	virtual ~Element();

    public slots:
	virtual bool refreshChildList();
    signals:
	void refreshCompleted( K2ch::Element *);
    protected slots:
	virtual void recieveData( KIO::Job *, const QByteArray& );

    protected:
        QCString * m_array;
        KIO::TransferJob * m_currentjob;
        QProgressDialog * m_progress;
    };

    class Base : public Element {
	Q_OBJECT
    public:
	Base() : Element() {}
	Base( const Base &_in ) : Element() { *this = _in; }
	Base& operator= ( const Base &_in ) { 
	    name = _in.name; topURL = _in.topURL; bbsmenu = _in.bbsmenu; 
	    return *this;
       	}

	virtual ~Base();

	QString name;
	KURL topURL;
	KURL bbsmenu;
	QPtrList<struct Category> categoryList;

    public slots:
	virtual bool refreshChildList(); 

    protected slots:
	void processBBSMenu( KIO::Job * );
    };

    class Category : public Element {
	Q_OBJECT
    public:
	Category() : Element() {}
	Category( const QString &_name, struct Base * _base ) : Element() { name = _name; base = _base; }
	Category( const Category &_in ) : Element() { *this = _in; } 
	Category& operator= ( const Category &_in ) {
	    name = _in.name; base = _in.base;
	    return *this;
       	}

	virtual ~Category();

	QString name;
	QPtrList<struct Board> boardList;
        struct Base * base;

    public slots:
	virtual bool refreshChildList();
    };

    class Board : public Element {
	Q_OBJECT
    public:
	Board() : Element(), m_dict( 509 ) {}
	Board( const Board &_in ) : Element(), m_dict( 509 ) { *this = _in; } 
	Board& operator= ( const Board &_in ) { name = _in.name; url = _in.url; 
	    subject_txt = _in.subject_txt; setting_txt = _in.setting_txt;
	    category = _in.category;
	    return *this;
       	}

	virtual ~Board();

	QString name;
	KURL url;
	KURL subject_txt;
	KURL setting_txt;
	QPtrList<struct Thread> threadList;
	struct Category * category;

    public slots:
	virtual bool refreshChildList(); 

    protected slots:
        void processSubject( KIO::Job * );

    private:
    	QDict<Thread> m_dict;
    };

    class Thread : public Element {
	Q_OBJECT
    public:
	Thread() : Element() {}
	Thread( const Thread &_in ) : Element() { *this = _in; prev_rescount = rescount; }
	Thread& operator= ( const Thread &_in ) { name = _in.name; 
	    sortkey = _in.sortkey; datnumber = _in.datnumber; rescount = _in.rescount;
	    url = _in.url; dat = _in.dat; board = _in.board; 
	    return *this;
	}

	QString name;
	QString datnumber;
	int sortkey;
	int rescount;
	int prev_rescount;
	KURL url;
	KURL dat;
	struct Board * board;

    public slots:
	void postMessage( const QString& name, const QString& mail, const QString& message );

    signals:
    	void postFinished( const QCString& response );
    };
}
#endif
// vim:sw=4
