
#include "k2ch.h"

#include <klocale.h>
#include <qtextcodec.h>
class QTextCodec;

#include <qprogressdialog.h>
class QProgressDialog;

#include <qregexp.h>
class QRegExp;

using namespace K2ch;

Element::~Element()
{
    if ( m_array ) delete m_array;
}

void Element::recieveData( KIO::Job *, const QByteArray &data)
{
    m_progress->setProgress( (m_progress->progress() < 80)?(m_progress->progress() + 4):m_progress->progress() );
    //printf("  board::recieveData() %d + %d\n", data.size(), m_array->length() );
    m_array->append( data.data() );
}

bool Element::refreshChildList()
{
    if( m_currentjob ) {
	return false;
    } else {
	return true;
    }
}

Base::~Base()
{
    if ( ! categoryList.autoDelete() ) categoryList.setAutoDelete( true );
    while( categoryList.remove() );
}

bool Base::refreshChildList()
{
    printf(" Base::refreshCategoryList()\n");
    if ( m_currentjob ) {
        return false;
    } else {
	m_progress = new QProgressDialog;
	m_progress->setLabel( new QLabel( QString("%1: %2").arg( name ).arg( i18n("Refresh the BBS menu.") ), m_progress ) );
	m_progress->setTotalSteps( 100 );
	m_progress->show();

	m_array = new QCString;

	m_currentjob = KIO::get( bbsmenu, false, false );
	connect( m_currentjob, SIGNAL( data(KIO::Job *, const QByteArray &) ),
		 this, SLOT( recieveData(KIO::Job *, const QByteArray &) ) );
	connect( m_currentjob, SIGNAL( result(KIO::Job *) ),
		 this, SLOT( processBBSMenu(KIO::Job *) ) );

	m_progress->setProgress( 10 );
	return true;
    }
}

void Base::processBBSMenu( KIO::Job * job )
{
    printf("  Base::processBBSMenu() length=%d\n", m_array->length() );
    if ( ! job->error() ) {
	QString input =  QTextCodec::codecForName("sjis")->toUnicode( *m_array );
	//QCString content = QTextCodec::codecForName("eucJP")->fromUnicode( input );
	//printf("    bbsmenu Content:\n%s\n", (const char*)content );
	
	QStringList lines = QStringList::split("\n", input );

	QRegExp category_r("<BR><BR><B>(.*)</B><BR>");
	QRegExp board_r("<A HREF=(.*)>(.*)</A>");

	QStringList::iterator it = lines.begin();
	int step = ( 100 - m_progress->progress() ) / lines.count();

	while( categoryList.remove() );
	for( it = lines.begin(); it != lines.end() && category_r.search(*it) == -1; ++it )
	    m_progress->setProgress( step + m_progress->progress() );

	//categoryList.setAutoDelete( true );
	for( ; it != lines.end(); ++it )
	{
	    if( category_r.search(*it) != -1 )
	    {
		QString name( category_r.cap(1) );

		K2ch::Category * new_cate = new K2ch::Category;
		new_cate->name = name;
		new_cate->base = this;
		//new_cate->boardList.setAutoDelete( true );

		categoryList.append( new_cate );
	    } else if ( board_r.search(*it) != -1 )
	    {
		KURL url( board_r.cap(1) );
		QString name( board_r.cap(2) );

		K2ch::Board * new_board = new K2ch::Board;
		new_board->name = name;
		new_board->url = url;
		new_board->subject_txt = url.url(-1).append("/subject.txt");
		new_board->subject_txt.setProtocol( "k2ch" );
		new_board->setting_txt = url.url(-1).append("/SETTING.TXT");
		new_board->setting_txt.setProtocol( "k2ch" );
		new_board->category = categoryList.last();

		new_board->category->boardList.append( new_board );
	    }
	    m_progress->setProgress( step + m_progress->progress() );
	}
    }

    delete m_progress;
    m_progress = 0;
    delete m_array;
    m_array = 0;
    m_currentjob = 0;

    emit refreshCompleted( this );
}

Category::~Category()
{
    if ( ! boardList.autoDelete() ) boardList.setAutoDelete( true );
    while ( boardList.remove() );
}

bool Category::refreshChildList()
{
    printf(" Category::refreshChildList()\n");
    if ( base ) {
        return base->refreshChildList();
    } else {
	return false;
    }
}

Board::~Board()
{
    m_dict.setAutoDelete( true );
}

bool Board::refreshChildList()
{
    printf(" board::refreshThreadList() %s %p\n", url.url().latin1(), static_cast<void*>(m_currentjob) );

    if ( m_currentjob ) {
	return false;
    } else
    {
	m_progress = new QProgressDialog;
	m_progress->setLabel( new QLabel( QString("%1: %2").arg( name ).arg( i18n("Refreshing the list of threads.") ), m_progress ) );
	m_progress->setTotalSteps( 100 );
	m_progress->show();
	
        m_array = new QCString;

        m_currentjob = KIO::get( subject_txt, false, false );
        connect( m_currentjob, SIGNAL( data(KIO::Job *, const QByteArray &) ),
    	    	 this, SLOT( recieveData(KIO::Job *, const QByteArray &) ) );
        connect( m_currentjob, SIGNAL( result(KIO::Job *) ),
	    	 this, SLOT( processSubject(KIO::Job *) ) );

	m_progress->setProgress( 10 );
	return true;
    }
}

void Board::processSubject( KIO::Job *job )
{
    printf(" board::processSubject() length=%d\n", m_array->length() );
    if ( ! job->error() ) {
	while( threadList.remove() );

	m_progress->setProgress( 90 );

	QTextCodec * sjis_codec = QTextCodec::codecForName( "sjis" );

	char * tmp = m_array->data();
	
	char * ttitle_start = 0;
	char * datnum_start = tmp;
	char * resnum_start = 0;
	char * ttitle_end = 0;
	char * datnum_end = 0;
	char * resnum_end = 0;

	int thread_count = 0;
	bool exit_loop = false;

	for( ; ! exit_loop; ++tmp ) {
	    switch( *tmp ) {
		case '.': // need the first '.';
		    if ( ! datnum_end > 0 ) {
			*(datnum_end = tmp) = '\0';
			ttitle_start = (tmp += 6 );
		    }
		    break;

		case '(': // need the last '('.
		    ttitle_end = tmp;
		    resnum_start = tmp + 1;
		    break;

		case ')': //need the last ')'.
		    resnum_end = tmp;
		    break;

		case '\0':
		    exit_loop = true;
		case '\n':
		    if ( datnum_start && datnum_end &&
			 ttitle_start && ttitle_end &&
			 resnum_start && resnum_end ) // maybe changed for others than 2ch.
		    {
			++thread_count;
			*tmp = '\0';

			*ttitle_end = '\0';
			QString ttitle = sjis_codec->toUnicode( ttitle_start );
			
			Thread * new_thread;
			if ( !( new_thread = m_dict[ ttitle ] ) )
			{
			    new_thread = new Thread;
			    if ( ! new_thread ) break;
			    new_thread->name = ttitle;
			    m_dict.insert( ttitle, new_thread );
			}

			new_thread->sortkey = thread_count;
			new_thread->board = this;

			if ( resnum_start && resnum_end && 
			    ( resnum_end - resnum_start ) > 0 ) {
			    *resnum_end = '\0';
			    new_thread->rescount = QString( resnum_start ).toInt();
			}
			if ( datnum_end ) {
			    new_thread->url = QString( "%1://%2/test/read.cgi%3/%4/" )
				            .arg( url.protocol() )
					    .arg( url.host() )
					    .arg( url.path(-1) )
					    .arg( datnum_start );
			    new_thread->dat = QString( "%1://%2%3/dat/%4.dat" )
					    .arg( "k2ch" )
					    .arg( url.host() )
					    .arg( url.path(-1) )
					    .arg( datnum_start );
			    new_thread->datnumber = QString( datnum_start );
			}

			threadList.append( new_thread );
		    }


		    ttitle_start = 0;
		    datnum_start = tmp + 1;
		    resnum_start = 0;
		    ttitle_end = 0;
		    datnum_end = 0;
		    resnum_end = 0;

		    break;

		default:
		    break;
	    } // switch ( tmp )
	} // while ( .... )
	m_progress->setProgress( 100 );
    } // if ( ! job->error() )

    delete m_array;
    delete m_progress;
    m_array = 0;
    m_currentjob = 0;

    emit refreshCompleted( this );
}

void Thread::postMessage( const QString& name, const QString& mail, const QString& message )
{
    QCString response;
    emit postFinished( response );
}
//#include "k2ch.moc.cpp"

// vim:sw=4
