/*
 * Copyright (C) 2001 Hideki Ikemoto <ikemo@wakaba.jp>
 */

#include "pref.h"

#include <klocale.h>
#include <kfontdialog.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>

#include "kitafontprefbase.h"

KitaPreferences::KitaPreferences()
    : KDialogBase(TreeList, i18n("Kita Preferences"),
                  Help|Default|Ok|Apply|Cancel, Ok)
{
    // this is the base class for your preferences dialog.  it is now
    // a Treelist dialog.. but there are a number of other
    // possibilities (including Tab, Swallow, and just Plain)
    QFrame *frame;
    frame = addPage(i18n("Font"), i18n("Font"));
    m_fontPage = new KitaFontPrefPage(frame);

//    frame = addPage(i18n("Second Page"), i18n("Page Two Options"));
//    m_pageTwo = new KitaPrefPageTwo(frame);
    
    connect(m_fontPage, SIGNAL(signalFontChanged(QFont&)), SIGNAL(signalFontChanged(QFont&)));
}

KitaFontPrefPage::KitaFontPrefPage(QWidget *parent)
    : KitaFontPrefBase(parent)
{
  connect(fontButton, SIGNAL(clicked()), SLOT(slotFontButtonClicked()));
}

void KitaFontPrefPage::slotFontButtonClicked()
{
  QFont font;

  if( KFontDialog::getFont(font, false, this) == QDialog::Accepted ) {
    fontButton->setText(font.family());
    emit signalFontChanged(font);
  }
}

KitaPrefPageTwo::KitaPrefPageTwo(QWidget *parent)
    : QFrame(parent)
{
    QHBoxLayout *layout = new QHBoxLayout(this);
    layout->setAutoAdd(true);

    new QLabel(i18n("Add something here"), this);
}
#include "pref.moc"
