#include "kitacacheinfo.h"

#include <kurl.h>

#include <qmap.h>
#include <qdatastream.h>

KitaCacheInfo* KitaCacheInfo::instance = 0;

KitaCacheInfo::KitaCacheInfo() : m_vestedDict()
{
}

KitaCacheInfo::~KitaCacheInfo()
{
}

KitaCacheInfo* KitaCacheInfo::getInstance()
{
  if( instance == 0 ) {
    instance = new KitaCacheInfo();
  }
  return instance;
}

int KitaCacheInfo::getVestedNum(const KURL& url)
{
  QString key = url.prettyURL();
  if(m_vestedDict.contains(key)) {
    return m_vestedDict[key];
  } else {
    return 0;
  }
}

void KitaCacheInfo::setVestedNum(const KURL& url, int num)
{
  m_vestedDict.insert(url.prettyURL(), num);
}
  
QDataStream& operator<<(QDataStream& s, KitaCacheInfo& c)
{
  s << c.m_vestedDict;
  return s;
}

QDataStream& operator>>(QDataStream& s, KitaCacheInfo& c)
{
  s >> c.m_vestedDict;
  return s;
}
