/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KITATHREADVIEW_H_
#define _KITATHREADVIEW_H_

#include <qwidget.h>
#include <qcstring.h>

#include <kurl.h>
#include <dom/dom_node.h>
#include <kparts/browserextension.h>

#include "kitathreadviewbase.h"

class KURL;
class KHTMLPart;

#include <qvaluestack.h> // for gcc-2.9x
template<class T> class QValueStack;

namespace KIO {
  class Job;
};

#include <dom/html_base.h>
namespace DOM {
  class HTMLBodyElement;
};

/**
 * 
 * Hideki Ikemoto
 **/

class KitaThreadView : public KitaThreadViewBase
{
  Q_OBJECT

public:
  KitaThreadView(QWidget *parent, const char *name=0);
  ~KitaThreadView();
  QString threadSubject() const;
  QStringList parseSearchQuery(const QString &input);
  void searchNext(const QStringList &input);
  void highLighten(bool yes, const QStringList &input);

public slots:
  void slotReceiveThreadData(KIO::Job* job, const QByteArray& data);
  void slotRedirection(KIO::Job* job, const KURL &);
  void slotThreadResult(KIO::Job* job);
  void slotWriteButtonClicked();
  void slotReceiveWriteResult(KIO::Job* job,  const QByteArray & data);
  void slotWriteResult(KIO::Job* job);
  void slotCanceled(KIO::Job* job);
  void slotDisplayContents(const QString& input, const KURL& urlOfInput = 0);
  void slotShowThread(const KURL& _datURL, const KURL& _boardURL, const QString& boardName = QString() );

protected:
  bool gotoAnchor(const QString& name);

protected slots:
  void slotDOMNodeActivated(const DOM::Node &node);
  bool gobackAnchor();
  void slotPopupMenu(KXMLGUIClient *, const QPoint&, const KURL&, const QString&, mode_t);
  void slotOpenURLRequest(const KURL&, const KParts::URLArgs&);

private: // Private attributes
  KHTMLPart* threadPart;
  QCString m_threadData;
  KURL m_datURL;
  KURL m_boardURL;
  KURL m_threadURL;
  QCString m_writeResult;
  int serverTime;
  QString m_boardID;
  QString m_datName;
  QString m_boardName;
  QWidget * m_parent;
  KIO::Job * m_currentJob;
  QString m_subject;
  QString m_contents;
  QStringList m_prevquery;
  int m_labelMaxLength;
  int m_rescount;
  int m_hitcount;
  int m_nextHit;
  QValueStack<QPoint> m_pointStack;
  
  void highLightenNodes(DOM::NodeList nodes, const QStringList &query);
  static QStringList lt_gt_spliter( const QString & input );
  void insertSearchCombo();
  KURL filterReadCGI(const KURL&);

private slots:
  void slotSearchButton();
  void slotHighLightenButton(bool yes);
  void slotOnURL(const QString& url);

signals:
  void showThreadCompleted();
  void datURLRedirected(const KURL& newDatURL);
  void signalChangeStatusbar(const QString&);
  //re-impl signals of KParts::Browserextension of KHTMLPart
  void openURLRequest( const KURL &url, const KParts::URLArgs &args = KParts::URLArgs() );
  void createNewWindow( const KURL &url, const KParts::URLArgs &args = KParts::URLArgs() );
  void setLocationBarURL( const QString &url );
  void enableAction( const char * name, bool enabled );
  void popupMenu(KXMLGUIClient *, const QPoint&, const KURL&, const QString&, mode_t);
  void setVestedNum(const KURL& , int );
  
  friend class KitaThreadPart;
};

#endif
