/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITATHREAD_H
#define KITATHREAD_H

#include <kurl.h>
#include <qdict.h>
#include <qvaluelist.h>

namespace Kita
{
    /**
    @author Hideki Ikemoto
    */
    class Thread
    {
        static QDict<Thread>* m_threadDict;

        KURL m_datURL;
        QString m_threadName;
        int m_resNum;
        int m_readNum;
        int m_viewPos;
        bool m_isOpened;
        QValueList< int > m_markList;

    public:
        Thread( const KURL& datURL );
        ~Thread();

        const KURL& datURL() const;

        const QString& threadName() const;
        void setThreadName( QString threadName );

        const int resNum() const;
        void setResNum( int num );

        const int readNum() const;
        void setReadNum( int num );

        const int viewPos() const;
        void setViewPos( int viewPos );

        bool isOpened() const;
        void setIsOpened( bool isOpend );

        const QValueList< int >& markList() const;
        void setMarkList( const QValueList< int >& markList );
        bool isMarked( int num );
        bool setMark( int num, bool newStatus );

        /*----------------------*/

        static Thread* getByURL( const KURL& datURL );
        static Thread* getByURLNew( const KURL& datURL );
        static void replace( const QString& fromURL, const QString& toURL );
    };
}

#endif
