/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   Permission is hereby granted, free of charge, to any person obtaining *
*   a copy of this software and associated documentation files (the       *
*   "Software"), to deal in the Software without restriction, including   *
*   without limitation the rights to use, copy, modify, merge, publish,   *
*   distribute, sublicense, and/or sell copies of the Software, and to    *
*   permit persons to whom the Software is furnished to do so, subject to *
*   the following conditions:                                             *
*                                                                         *
*   The above copyright notice and this permission notice shall be        *
*   included in all copies or substantial portions of the Software.       *
*                                                                         *
*   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,       *
*   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF    *
*   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*
*   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR     *
*   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, *
*   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR *
*   OTHER DEALINGS IN THE SOFTWARE.                                       *
***************************************************************************/

#ifndef _QCP932CODEC_H_
#define _QCP932CODEC_H_

#include <qtextcodec.h>

class QJpUnicodeConv;
/**
 * 
 * Hideki Ikemoto
 **/
class QCp932Codec : public QTextCodec
{
private:
    QJpUnicodeConv* conv;
public:
    QCp932Codec();
    ~QCp932Codec();
    virtual const char * name() const;
    virtual const char * mimeName() const;
    virtual int mibEnum() const;
    virtual QTextDecoder* makeDecoder() const;
    //  virtual QTextEncoder* makeEncoder() const;
    //  virtual QString toUnicode(const char* chars, int len) const;
    //  using QTextCodec::fromUnicode;
    virtual QCString fromUnicode( const QString& uc, int& lenInOut ) const;
    //  virtual bool canEncode(QChar ch) const;
    //  virtual bool canEncode(const QString& s) const;
    virtual int heuristicContentMatch( const char* chars, int len ) const;
    virtual int heuristicNameMatch( const char * hint ) const;
};

class QCp932Decoder : public QTextDecoder
{
private:
    QJpUnicodeConv* conv;

public:
    QCp932Decoder( QJpUnicodeConv* _conv );
    ~QCp932Decoder();
    virtual QString toUnicode( const char* chars, int len );
};

#endif
