/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto, 2004 by 421                     *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITATABWIDGETBASE_H
#define KITATABWIDGETBASE_H

#include <qtabwidget.h>
#include <kxmlguiclient.h>
#include <kparts/partmanager.h>
#include <kparts/browserextension.h>

#include <qtabbar.h>

#include <kdockwidget.h>

#include <qevent.h>
#include <qdict.h>

class KLibFactory;
class KURL;
class KitaImgView;
class KitaTabBase;
class QIconSet;
class KPopupMenu;

namespace KParts
{
    class DockMainWindow;
}

/* ID of user defined event */
#define EVENT_CloseTab ( QEvent::User + 100 )
#define EVENT_ShowDock ( QEvent::User + 101 )
#define EVENT_FitImageToWinEvent ( QEvent::User + 102 )
#define EVENT_CancelMoszicEvent ( QEvent::User + 103 )



/*-----------------------------------------------*/


class KitaTabWidgetBase : public QTabWidget, public KXMLGUIClient
{
    Q_OBJECT

protected:
    KParts::PartManager* m_manager;


public:
    KitaTabWidgetBase( QWidget* parent = 0, const char* name = 0, WFlags f = 0 );
    virtual ~KitaTabWidgetBase();

    virtual void addTab( QWidget* w, const QString& label );
    virtual void addTab( QWidget* w, const QIconSet & iconset, const QString& label );
    virtual void insertTab( QWidget* w, const QString& label, int index = -1 );
    virtual void removePage( QWidget* w );
    virtual void setTabLabel( QWidget * w, const QString & label );

public slots:
    void slotCurrentChanged( QWidget* w );
    void slotShowPart( const KURL&, const QString&, const QString& );
    void slotCloseTab( int num );


protected:
    virtual void customEvent( QCustomEvent * e );
    virtual void deleteWidget( QWidget* w );
    KParts::Part* findPartFromWidget( QWidget* w );


private:
    void connectSignals();



    /*------------------------------------*/
    /* common tab actions */

private:
    void setupActions();

public slots:
    void slotConfigureKeys();
    void slotPrevTab();
    void slotNextTab();
    void slotCloseCurrentTab();
    void slotCloseOtherTab( int idx = -1 );
    void slotCloseRightTab( int idx = -1 );
    void slotCloseLeftTab( int idx = -1 );
    void slotCloseAllTab();

signals:
    void switchToBoard();
    void switchToSubject();
    void switchToThread();
    void switchToKitanavi();
    void switchToImgview();
    void switchToWritedock();

    void setMainURLLine( const KURL& url );
    void setMainCaption( const QString& captionStr );
    void setMainStatusbar( const QString& statusStr );
    void openURLRequestExt( const KURL& url, const KParts::URLArgs& args = KParts::URLArgs(),
                            QString mimetype = QString::null,
                            int usr1 = 0, int usr2 = 0,
                            const KURL& usrUrl1 = KURL(),
                            const KURL& usrUrl2 = KURL(),
                            const QString& usrStr1 = QString::null,
                            const QString& usrStr2 = QString::null );
};


/*-------------------------------------------------*/




class KitaTabBarBase : public QTabBar
{
    Q_OBJECT

public:
    KitaTabBarBase( QWidget* parent = 0, const char* name = 0 );
    ~KitaTabBarBase();

    void adjustTabWidth( KitaTabBase* newTab );

private:
    virtual void showPopupMenu( int idx, QPoint global );
    bool shrinkTab( KitaTabBase* newTab );
    bool expandTab();
    int getWidthOfTabs();

protected:
    virtual void mousePressEvent( QMouseEvent *e );
};



/*-------------------------------------------------*/


class KitaTabBase : public QTab
{
    QString m_fullText;
    unsigned int m_textlng;

public:
    KitaTabBase( const QString & text );
    ~KitaTabBase();

    QString getFullText() const;
    const unsigned int getTextLng() const;
    void setFullText( const QString& text );
};



/*-------------------------------------------------*/



class KitaDockWidgetBase : public KDockWidget
{

    Q_OBJECT

    bool m_docked;
    bool m_tabbed;
    bool m_closeButtonClicked;
    KParts::DockMainWindow* m_parentDock;
    QDict<KDockWidget>* m_dockDict;

public:
    KitaDockWidgetBase( KDockManager* dockManager,
                        const char* name,
                        const QPixmap &pixmap,
                        QWidget* parent = 0L,
                        const QString& strCaption = QString::null,
                        const QString& strTabPageLabel = QString::fromLatin1( " " ),
                        WFlags f = 0 );
    ~KitaDockWidgetBase();

    void showDock( bool active = TRUE, bool force = TRUE );
    void loadSession();
    void saveSession();
    void setSession( bool docked, bool tabbed );


public slots:
    void slotShowPart( const KURL&, const QString&, const QString& );
    void slotShowDock( bool activate = TRUE , bool force = TRUE );
    void slotHideDock();
    void slotToggleShowHide();


protected:
    void windowActivationChange( bool );
    virtual void closeEvent( QCloseEvent* e );
    virtual void customEvent( QCustomEvent * e );


private slots:
    void slotSaveDocStatus();
    void slotHeaderCloseButtonClicked();
    void slotIsKitaActive();


signals:
    void windowDeactivated();
    void isKitaActive();
    void kitaIsActive();
    void checkToggleAction( bool );
};



/*------------------------------------------------------------------*/

/* user defined events */

class CloseTabEvent : public QCustomEvent
{
    int m_pageindex;

public:

    CloseTabEvent( int idx )
            : QCustomEvent( EVENT_CloseTab ), m_pageindex( idx ) {}

    const int getIndex() const { return m_pageindex; }
};


class ShowDockEvent : public QCustomEvent
{
    bool m_activate;
    bool m_force;

public:
    ShowDockEvent( bool activate, bool force ) : QCustomEvent( EVENT_ShowDock )
    , m_activate( activate ), m_force( force ) {}

    const bool getActivate() const { return m_activate; }
    const bool getForce() const { return m_force; }
};


/* FitImageToWinEvent is used in kitaimgviewer.cpp */
class FitImageToWinEvent : public QCustomEvent
{
    QWidget* m_w;

public:
    FitImageToWinEvent( QWidget* w ) : QCustomEvent( EVENT_FitImageToWinEvent ), m_w( w ) {}
    QWidget* getWidget() const { return m_w; }
};


/* CancelMosaicEvent is used in kitaimgviewer.cpp */
class CancelMosaicEvent : public QCustomEvent
{
    KitaImgView* m_imgview;

public:
    CancelMosaicEvent( KitaImgView* imgview ) : QCustomEvent( EVENT_CancelMoszicEvent ), m_imgview( imgview ) {}
    KitaImgView* getView() const { return m_imgview; }
};



#endif
