/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef KITASIGNALCOLLECTION_H
#define KITASIGNALCOLLECTION_H

#include <kparts/browserextension.h>

#include <qobject.h>

namespace Kita
{
    /**
    @author Hideki Ikemoto
    */
    class SignalCollection : public QObject
    {
        Q_OBJECT

        static SignalCollection* instance;

        SignalCollection();
        ~SignalCollection();
    public:
        static SignalCollection* getInstance();

    signals:
        /*--------------------------------*/

        /* to : KitaMainWindow */
        void bookmarked( const QString& datURL, bool on );
        void openURLRequest( const KURL& url, const KParts::URLArgs& args = KParts::URLArgs() );
        void openURLRequestExt( const KURL& url, const KParts::URLArgs& args = KParts::URLArgs(),
                                QString mimetype = QString::null,
                                int usr1 = 0, int usr2 = 0,
                                const KURL& usrUrl1 = KURL(),
                                const KURL& usrUrl2 = KURL(),
                                const QString& usrStr1 = QString::null,
                                const QString& usrStr2 = QString::null );
        void setMainURLLine( const KURL& url );
        void setMainCaption( const QString& captionStr );
        void setMainStatusbar( const QString& statusStr );

        /*--------------------------------*/

        /* from: KitaDockWidgetBase            */
        /* to  : KitaHTMLPart                  */
        /* see also KitaHTMLPart::slotOnURL    */
        void windowDeactivated();
        void kitaIsActive();

        /* from: KitaHTMLPart                  */
        /* to  : KitaDockWidgetBase            */
        /* see also KitaHTMLPart::slotOnURL    */
        void isKitaActive();

        /*--------------------------------*/

        /* to : KitaHTMLPart */
        void redrawHTMLPart( const KURL& url, bool force );
        void redrawAllHTMLPart( bool force );
        void setFontOfHTMLPart();
        void setStyleSheetOfHTMLPart();

        /*--------------------------------*/

        /* from: KitaThreadView::setFocus            */
        /* emitted when KitaThreadView is activated. */
        void activateThreadView( const KURL& );

        /* to : KitaThreadTabWidget */
        void updateThreadTab( const KURL& url );
        void closeThreadTab( const KURL& url );

        /* to : KitaThreadDock */
        void showKitaNavi( const KURL& , int , int );
        void showKitaNaviByID( const KURL& , QString );
        void showKitaNaviByWord( const KURL& , QString );
        void showKitaNaviByName( const KURL& , QString );
        void showKitaNaviResTree( const KURL&, int );
        void showKitaNaviRevResTree( const KURL&, int );
        void switchToThread();
        void switchToKitanavi();

        /*--------------------------------*/

        /* to : FavoriteListView */
        void favoritesUpdated();

        /* to : KitaBoardView, FavoriteListView */
        void updateSubjectTab( const KURL& url );

        /* to: KitaSubjectDock */
        void switchToSubject();

        /*--------------------------------*/

        /* to: KitaBBSDock */
        void switchToBoard();

        /*--------------------------------*/

        /* to: KitaImgTabWidget */
        void redrawImage( const KURL& );

        /* to: KitaImgDock */
        void switchToImgview();

        /*--------------------------------*/

        /* to : KitaWriteTabWidget */
        void closeWriteTab( const KURL& url );

        /* to : KitaWriteDock */
        void showWriteView( const KURL& , const QString& );
        void createNewThread( const KURL& , const QString&, const QString& );
        void switchToWritedock();
    };

}

#endif
