/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITABOARDVIEW_H_
#define _KITABOARDVIEW_H_

#include <kurl.h>
#include "threadlistview.h"

class QWidget;
class KListViewItem;

/**
 *
 * @author Hideki Ikemoto <ikemo@users.sourceforge.jp>
 **/
class KitaBoardView : public Kita::ThreadListView
{
    Q_OBJECT

public:
    KitaBoardView( QWidget* parent, const char* name = 0 );
    ~KitaBoardView();
    void init();
    const KURL boardURL();
    void toggleShowOldLogs();

public slots:
    virtual void setFocus();
    void slotFocusSearchCombo();
    void reloadSubject();
    void slotCreateNewThread();
    void loadBoard( const KURL& url, bool online = TRUE );
    void setFont( const QFont& font );
    void slotUpdateSubject( const KURL& url );

private:
    KURL m_boardURL;
    int m_unreadNum, m_readNum, m_newNum;
    bool m_showOldLogs;
    bool m_enableSizeChange;
    void UpdateKindLabel();
    void deleteLog( const KURL& url );
    void loadLayout();
    void updateListViewItem( QListViewItem* item, Kita::Thread* thread, const QDateTime& current, int id, int order );
    bool eventFilter( QObject* watched, QEvent* e );
    void saveHeaderOnOff();
    void loadHeaderOnOff();
    bool autoResize();
    void setAutoResize( bool flag );

private slots:
    void loadThread( QListViewItem* item );
    void slotContextMenuRequested( QListViewItem*, const QPoint&, int );
    void slotCloseButton();
    void slotSizeChange( int section, int oldSize, int newSize );

signals:
    void loadBoardCompleted( const KURL& );
    void closeThreadTab( const KURL& );
    void createNewThread( const KURL& , const QString&, const QString& );
    void closeCurrentTab();
};

#endif
