/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#include "aboneprefpage.h"

#include <ktextedit.h>

#include "libkita/kitaconfig.h"
#include "libkita/signalcollection.h"

using namespace Kita;

AbonePrefPage::AbonePrefPage( QWidget *parent, const char *name )
        : Kita::AbonePrefBase( parent, name )
{
    idAboneText->setText( KitaConfig::aboneIDList().join( "\n" ) );
    nameAboneText->setText( KitaConfig::aboneNameList().join( "\n" ) );
    wordAboneText->setText( KitaConfig::aboneWordList().join( "\n" ) );

    connect( idAboneText, SIGNAL( textChanged() ), SLOT( slotTextChanged() ));
    connect( nameAboneText, SIGNAL( textChanged() ), SLOT( slotTextChanged() ));
    connect( wordAboneText, SIGNAL( textChanged() ), SLOT( slotTextChanged() ));

    Kita::SignalCollection* signalCollection = Kita::SignalCollection::getInstance();
    connect( this, SIGNAL( redrawAllHTMLPart( bool ) ),
             signalCollection, SIGNAL( redrawAllHTMLPart( bool ) ));

    m_changed = FALSE;
}

AbonePrefPage::~AbonePrefPage()
{}

void AbonePrefPage::slotTextChanged()
{
    m_changed = TRUE;
    emit changed();
}

void AbonePrefPage::apply()
{
    if( m_changed )
    {
        QString idText = idAboneText->text();
        QStringList idList = QStringList::split( '\n', idText );
        KitaConfig::setAboneIDList( idList );

        QString nameText = nameAboneText->text();
        QStringList nameList = QStringList::split( '\n', nameText );
        KitaConfig::setAboneNameList( nameList );

        QString wordText = wordAboneText->text();
        QStringList wordList = QStringList::split( '\n', wordText );
        KitaConfig::setAboneWordList( wordList );

        emit redrawAllHTMLPart( FALSE ); /* to all HTMLPart */
    }

    m_changed = FALSE;
}

#include "aboneprefpage.moc"
