/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "threadtest.h"
#include "../board.h"

using namespace Kita;

void ThreadTest::setUp()
{
    Kita::Board::setName( "http://pc.2ch.net/linux/", "Linux" );
    Kita::Thread::setName( "http://pc.2ch.net/linux/dat/1069738960.dat",
    "Kita - 2ch client for KDE" );
    m_normal = Kita::Thread::getByURL( "http://pc.2ch.net/linux/dat/1069738960.dat" );

    Kita::Board::setName( "http://pc.2ch.net/unix/", "Unix" );
    Kita::Thread::setName( "http://pc.2ch.net/unix/dat/1069738960.dat", "a thread" );
}

void ThreadTest::tearDown()
{
}

void ThreadTest::testDatURL()
{
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/dat/1069738960.dat"),
                          m_normal->datURL() );
}

void ThreadTest::testURL()
{
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/test/read.cgi/linux/1069738960/"),
                          m_normal->url() );
}

void ThreadTest::testDatID()
{
    CPPUNIT_ASSERT_EQUAL( QString( "1069738960" ), m_normal->datID() );
}

void ThreadTest::testResNum()
{
    CPPUNIT_ASSERT_EQUAL( 0, m_normal->resNum() );
}

void ThreadTest::testName()
{
    CPPUNIT_ASSERT_EQUAL( QString( "Kita - 2ch client for KDE" ),
                          m_normal->name() );
}

void ThreadTest::testBoardName()
{
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), m_normal->boardName() );
}

void ThreadTest::testBoardURL()
{
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc.2ch.net/linux/" ), m_normal->boardURL() );
}

void ThreadTest::testBoardID()
{
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), m_normal->boardID() );
}

void ThreadTest::testReplace()
{
    Kita::Thread::replace( QString( "http://pc.2ch.net/unix/" ),
                           QString( "http://pc3.2ch.net/unix/" ) );
    Kita::Thread* unix = Kita::Thread::getByURL( "http://pc3.2ch.net/unix/dat/1069738960.dat" );
    
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc3.2ch.net/unix/dat/1069738960.dat"),
                          unix->datURL() );
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc3.2ch.net/test/read.cgi/unix/1069738960/"),
                          unix->url() );
    CPPUNIT_ASSERT_EQUAL( QString( "1069738960" ), unix->datID() );
    CPPUNIT_ASSERT_EQUAL( 0, unix->resNum() );
    CPPUNIT_ASSERT_EQUAL( QString( "a thread" ),
                          unix->name() );
    CPPUNIT_ASSERT_EQUAL( QString( "Unix" ), unix->boardName() ); // error
    CPPUNIT_ASSERT_EQUAL( QString( "http://pc3.2ch.net/unix/" ), unix->boardURL() );
    CPPUNIT_ASSERT_EQUAL( QString( "unix" ), unix->boardID() );
}
