/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "boardtest.h"

using namespace Kita;

void BoardTest::setUp()
{
    Board::setName( "http://pc.2ch.net/linux/", "Linux" );
    Board::setName( "http://pc.2ch.net/unix/", "U**x" );
    Board::setName( "http://pc.2ch.net/unix/", "Unix" );
}

void BoardTest::tearDown()
{
}

void BoardTest::testID()
{
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), Kita::Board::getID( "http://pc.2ch.net/linux/" ) );
    CPPUNIT_ASSERT_EQUAL( QString( "unix" ), Kita::Board::getID( "http://pc.2ch.net/unix/" ) );
}

void BoardTest::testStaticName()
{
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), Kita::Board::getName( "http://pc.2ch.net/linux/" ) );
    CPPUNIT_ASSERT_EQUAL( QString( "Unix" ), Kita::Board::getName( "http://pc.2ch.net/unix/" ) );
    CPPUNIT_ASSERT_EQUAL( QString::null, Kita::Board::getName( QString::null ) );
}

void BoardTest::testReplace()
{
    Kita::Board::replace( QString( "http://pc.2ch.net/linux/" ), QString( "http://pc3.2ch.net/linux/" ) );
    
    CPPUNIT_ASSERT_EQUAL( QString( "linux" ), Kita::Board::getID( "http://pc3.2ch.net/linux/" ) );
    CPPUNIT_ASSERT_EQUAL( QString( "Linux" ), Kita::Board::getName( "http://pc3.2ch.net/linux/" ) );
}
